/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl.shorthand;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.phloc.css.property.CSSPropertyFree;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.writer.CSSWriterSettings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class CSSShortHandDescriptor {
    private final ECSSProperty m_eProperty;
    private final List<CSSPropertyWithDefaultValue> m_aSubProperties;
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public CSSShortHandDescriptor(@Nonnull ECSSProperty eProperty, CSSPropertyWithDefaultValue ... aSubProperties) {
        ValueEnforcer.notNull((Object)eProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])aSubProperties, (String)"SubProperties");
        this.m_eProperty = eProperty;
        this.m_aSubProperties = ContainerHelper.newList((Object[])aSubProperties);
        int nMinArgs = 0;
        int nMaxArgs = 0;
        int nMax = aSubProperties.length;
        int i = 0;
        while (i < nMax) {
            CSSPropertyWithDefaultValue aSubProperty = aSubProperties[i];
            ICSSProperty aProp = aSubProperty.getProperty();
            if (aProp instanceof CSSPropertyFree && i < nMax - 1) {
                throw new IllegalArgumentException("The SubProperty " + aSubProperty + " may not use an unspecified CSSPropertyFree except for the last element!");
            }
            nMinArgs += aProp.getMinimumArgumentCount();
            nMaxArgs += aProp.getMaximumArgumentCount();
            ++i;
        }
        this.m_nMinArgCount = nMinArgs;
        this.m_nMaxArgCount = nMaxArgs;
    }

    @Nonnull
    public ECSSProperty getProperty() {
        return this.m_eProperty;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPropertyWithDefaultValue> getAllSubProperties() {
        return ContainerHelper.newList(this.m_aSubProperties);
    }

    @OverrideOnDemand
    protected void modifyExpressionMembers(@Nonnull List<ICSSExpressionMember> aExpressionMembers) {
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getSplitIntoPieces(@Nonnull CSSDeclaration aDeclaration) {
        ValueEnforcer.notNull((Object)aDeclaration, (String)"Declaration");
        if (!aDeclaration.getProperty().equals(this.m_eProperty.getName())) {
            throw new IllegalArgumentException("Cannot split a '" + aDeclaration.getProperty() + "' as a '" + this.m_eProperty.getName() + "'");
        }
        int nSubProperties = this.m_aSubProperties.size();
        ArrayList<CSSDeclaration> ret = new ArrayList<CSSDeclaration>();
        List<ICSSExpressionMember> aExpressionMembers = aDeclaration.getExpression().getAllMembers();
        this.modifyExpressionMembers(aExpressionMembers);
        int nExpressionMembers = aExpressionMembers.size();
        CSSWriterSettings aCWS = new CSSWriterSettings(ECSSVersion.CSS30, false);
        boolean[] aHandledSubProperties = new boolean[nSubProperties];
        int nExprMemberIndex = 0;
        while (nExprMemberIndex < nExpressionMembers) {
            ICSSExpressionMember aMember = aExpressionMembers.get(nExprMemberIndex);
            int nSubPropIndex = 0;
            while (nSubPropIndex < nSubProperties) {
                CSSPropertyWithDefaultValue aSubProp;
                ICSSProperty aProperty;
                int nMinArgs;
                if (!aHandledSubProperties[nSubPropIndex] && nExprMemberIndex + (nMinArgs = (aProperty = (aSubProp = this.m_aSubProperties.get(nSubPropIndex)).getProperty()).getMinimumArgumentCount()) - 1 < nExpressionMembers) {
                    StringBuilder aSB = new StringBuilder();
                    int k = 0;
                    while (k < nMinArgs) {
                        String sValue = aMember.getAsCSSString(aCWS, 0);
                        if (aSB.length() > 0) {
                            aSB.append(' ');
                        }
                        aSB.append(sValue);
                        ++k;
                    }
                    if (aProperty.isValidValue(aSB.toString())) {
                        CSSExpression aExpr = new CSSExpression();
                        int k2 = 0;
                        while (k2 < nMinArgs) {
                            aExpr.addMember(aExpressionMembers.get(nExprMemberIndex + k2));
                            ++k2;
                        }
                        ret.add(new CSSDeclaration(aSubProp.getProperty().getProp().getName(), aExpr));
                        nExprMemberIndex += nMinArgs - 1;
                        aHandledSubProperties[nSubPropIndex] = true;
                        break;
                    }
                }
                ++nSubPropIndex;
            }
            ++nExprMemberIndex;
        }
        int nSubPropIndex = 0;
        while (nSubPropIndex < nSubProperties) {
            if (!aHandledSubProperties[nSubPropIndex]) {
                CSSPropertyWithDefaultValue aSubProp = this.m_aSubProperties.get(nSubPropIndex);
                CSSExpression aExpr = new CSSExpression();
                aExpr.addMember(new CSSExpressionMemberTermSimple(aSubProp.getDefaultValue()));
                ret.add(new CSSDeclaration(aSubProp.getProperty().getProp().getName(), aExpr));
            }
            ++nSubPropIndex;
        }
        return ret;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Enum)this.m_eProperty).append("subProperties", this.m_aSubProperties).toString();
    }
}

