/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSNamespaceRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSSupportsRule;
import com.phloc.css.decl.CSSUnknownRule;
import com.phloc.css.decl.CSSViewportRule;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CascadingStyleSheet
implements ICSSSourceLocationAware,
Serializable {
    private final List<CSSImportRule> m_aImportRules = new ArrayList<CSSImportRule>();
    private final List<CSSNamespaceRule> m_aNamespaceRules = new ArrayList<CSSNamespaceRule>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasImportRules() {
        return !this.m_aImportRules.isEmpty();
    }

    @Nonnegative
    public int getImportRuleCount() {
        return this.m_aImportRules.size();
    }

    @Nullable
    public CSSImportRule getImportRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSImportRule)ContainerHelper.getSafe(this.m_aImportRules, (int)nIndex);
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnull CSSImportRule aImportRule) {
        ValueEnforcer.notNull((Object)aImportRule, (String)"ImportRule");
        this.m_aImportRules.add(aImportRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addImportRule(@Nonnegative int nIndex, @Nonnull CSSImportRule aImportRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aImportRule, (String)"ImportRule");
        if (nIndex >= this.getImportRuleCount()) {
            this.m_aImportRules.add(aImportRule);
        } else {
            this.m_aImportRules.add(nIndex, aImportRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeImportRule(@Nullable CSSImportRule aImportRule) {
        return EChange.valueOf((boolean)this.m_aImportRules.remove(aImportRule));
    }

    @Nonnull
    public EChange removeImportRule(@Nonnegative int nImportRuleIndex) {
        if (nImportRuleIndex < 0 || nImportRuleIndex >= this.m_aImportRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.remove(nImportRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllImportRules() {
        if (this.m_aImportRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aImportRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSImportRule> getAllImportRules() {
        return ContainerHelper.newList(this.m_aImportRules);
    }

    public boolean hasNamespaceRules() {
        return !this.m_aNamespaceRules.isEmpty();
    }

    @Nonnegative
    public int getNamespaceRuleCount() {
        return this.m_aNamespaceRules.size();
    }

    @Nullable
    public CSSNamespaceRule getNamespaceRuleAtIndex(@Nonnegative int nIndex) {
        return (CSSNamespaceRule)ContainerHelper.getSafe(this.m_aNamespaceRules, (int)nIndex);
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnull CSSNamespaceRule aNamespaceRule) {
        ValueEnforcer.notNull((Object)aNamespaceRule, (String)"NamespaceRule");
        this.m_aNamespaceRules.add(aNamespaceRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addNamespaceRule(@Nonnegative int nIndex, @Nonnull CSSNamespaceRule aNamespaceRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aNamespaceRule, (String)"NamespaceRule");
        if (nIndex >= this.getNamespaceRuleCount()) {
            this.m_aNamespaceRules.add(aNamespaceRule);
        } else {
            this.m_aNamespaceRules.add(nIndex, aNamespaceRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nullable CSSNamespaceRule aNamespaceRule) {
        return EChange.valueOf((boolean)this.m_aNamespaceRules.remove(aNamespaceRule));
    }

    @Nonnull
    public EChange removeNamespaceRule(@Nonnegative int nNamespaceRuleIndex) {
        if (nNamespaceRuleIndex < 0 || nNamespaceRuleIndex >= this.m_aNamespaceRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aNamespaceRules.remove(nNamespaceRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllNamespaceRules() {
        if (this.m_aNamespaceRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aNamespaceRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSNamespaceRule> getAllNamespaceRules() {
        return ContainerHelper.newList(this.m_aNamespaceRules);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nullable
    public ICSSTopLevelRule getRuleAtIndex(@Nonnegative int nIndex) {
        return (ICSSTopLevelRule)ContainerHelper.getSafe(this.m_aRules, (int)nIndex);
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        this.m_aRules.add(aRule);
        return this;
    }

    @Nonnull
    public CascadingStyleSheet addRule(@Nonnegative int nIndex, @Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        if (nIndex >= this.getRuleCount()) {
            this.m_aRules.add(aRule);
        } else {
            this.m_aRules.add(nIndex, aRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nullable ICSSTopLevelRule aRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(aRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(nRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllRules() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    public boolean hasStyleRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSStyleRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getStyleRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSStyleRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSStyleRule getStyleRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSStyleRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSStyleRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSStyleRule> getAllStyleRules() {
        ArrayList<CSSStyleRule> ret = new ArrayList<CSSStyleRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSStyleRule)) continue;
            ret.add((CSSStyleRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasPageRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSPageRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getPageRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSPageRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSPageRule getPageRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSPageRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSPageRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSPageRule> getAllPageRules() {
        ArrayList<CSSPageRule> ret = new ArrayList<CSSPageRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSPageRule)) continue;
            ret.add((CSSPageRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasMediaRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSMediaRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getMediaRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSMediaRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSMediaRule getMediaRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSMediaRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSMediaRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaRule> getAllMediaRules() {
        ArrayList<CSSMediaRule> ret = new ArrayList<CSSMediaRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSMediaRule)) continue;
            ret.add((CSSMediaRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasFontFaceRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSFontFaceRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getFontFaceRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSFontFaceRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSFontFaceRule getFontFaceRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSFontFaceRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSFontFaceRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSFontFaceRule> getAllFontFaceRules() {
        ArrayList<CSSFontFaceRule> ret = new ArrayList<CSSFontFaceRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSFontFaceRule)) continue;
            ret.add((CSSFontFaceRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasKeyframesRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSKeyframesRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getKeyframesRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSKeyframesRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSKeyframesRule getKeyframesRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSKeyframesRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSKeyframesRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesRule> getAllKeyframesRules() {
        ArrayList<CSSKeyframesRule> ret = new ArrayList<CSSKeyframesRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSKeyframesRule)) continue;
            ret.add((CSSKeyframesRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasViewportRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSViewportRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getViewportRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSViewportRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSViewportRule getViewportRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSViewportRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSViewportRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSViewportRule> getAllViewportRules() {
        ArrayList<CSSViewportRule> ret = new ArrayList<CSSViewportRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSViewportRule)) continue;
            ret.add((CSSViewportRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasSupportsRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSSupportsRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getSupportsRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSSupportsRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSSupportsRule getSupportsRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSSupportsRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSSupportsRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSupportsRule> getAllSupportsRules() {
        ArrayList<CSSSupportsRule> ret = new ArrayList<CSSSupportsRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSSupportsRule)) continue;
            ret.add((CSSSupportsRule)aTopLevelRule);
        }
        return ret;
    }

    public boolean hasUnknownRules() {
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSUnknownRule)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int getUnknownRuleCount() {
        int ret = 0;
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSUnknownRule)) continue;
            ++ret;
        }
        return ret;
    }

    @Nullable
    public CSSUnknownRule getUnknownRuleAtIndex(@Nonnegative int nIndex) {
        if (nIndex >= 0) {
            int nCurIndex = 0;
            for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
                if (!(aTopLevelRule instanceof CSSUnknownRule)) continue;
                if (nCurIndex == nIndex) {
                    return (CSSUnknownRule)aTopLevelRule;
                }
                ++nCurIndex;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSUnknownRule> getAllUnknownRules() {
        ArrayList<CSSUnknownRule> ret = new ArrayList<CSSUnknownRule>();
        for (ICSSTopLevelRule aTopLevelRule : this.m_aRules) {
            if (!(aTopLevelRule instanceof CSSUnknownRule)) continue;
            ret.add((CSSUnknownRule)aTopLevelRule);
        }
        return ret;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CascadingStyleSheet rhs = (CascadingStyleSheet)o;
        return this.m_aImportRules.equals(rhs.m_aImportRules) && this.m_aNamespaceRules.equals(rhs.m_aNamespaceRules) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aImportRules).append(this.m_aNamespaceRules).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("importRules", this.m_aImportRules).append("namespaceRules", this.m_aNamespaceRules).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

