/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSDataURL;
import com.phloc.css.utils.CSSDataURLHelper;
import com.phloc.css.utils.CSSURLHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSURI
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sURI;
    private CSSSourceLocation m_aSourceLocation;

    public CSSURI(@Nonnull @Nonempty String sURI) {
        this.setURI(sURI);
    }

    @Nonnull
    @Nonempty
    public String getURI() {
        return this.m_sURI;
    }

    @Nonnull
    public CSSURI setURI(@Nonnull @Nonempty String sURI) {
        ValueEnforcer.notEmpty((CharSequence)sURI, (String)"URI");
        if (CSSURLHelper.isURLValue(sURI)) {
            throw new IllegalArgumentException("Only the URI and not the CSS-URI value must be passed!");
        }
        this.m_sURI = sURI;
        return this;
    }

    public boolean isDataURL() {
        return CSSDataURLHelper.isDataURL(this.m_sURI);
    }

    @Nullable
    public CSSDataURL getAsDataURL() {
        return CSSDataURLHelper.parseDataURL(this.m_sURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, aSettings.isQuoteURLs());
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSURI rhs = (CSSURI)o;
        return this.m_sURI.equals(rhs.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

