/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSupportsConditionMember;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware,
ICSSVersionAware {
    private final List<ICSSSupportsConditionMember> m_aConditionMembers = new ArrayList<ICSSSupportsConditionMember>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSupportConditionMembers() {
        return !this.m_aConditionMembers.isEmpty();
    }

    @Nonnegative
    public int getSupportsConditionMemberCount() {
        return this.m_aConditionMembers.size();
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        this.m_aConditionMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addSupportConditionMember(@Nonnegative int nIndex, @Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        if (nIndex >= this.getSupportsConditionMemberCount()) {
            this.m_aConditionMembers.add(aMember);
        } else {
            this.m_aConditionMembers.add(nIndex, aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnull ICSSSupportsConditionMember aMember) {
        return EChange.valueOf((boolean)this.m_aConditionMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeSupportsConditionMember(@Nonnegative int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_aConditionMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aConditionMembers.remove(nIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllSupportsConditionMembers() {
        if (this.m_aConditionMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aConditionMembers.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSSupportsConditionMember getSupportsConditionMemberAtIndex(@Nonnegative int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_aConditionMembers.size()) {
            return null;
        }
        return this.m_aConditionMembers.get(nIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSupportsConditionMember> getAllSupportConditionMembers() {
        return ContainerHelper.newList(this.m_aConditionMembers);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nonnull
    public CSSSupportsRule addRule(@Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        this.m_aRules.add(aRule);
        return this;
    }

    @Nonnull
    public CSSSupportsRule addRule(@Nonnegative int nIndex, @Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        if (nIndex >= this.getRuleCount()) {
            this.m_aRules.add(aRule);
        } else {
            this.m_aRules.add(nIndex, aRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule aRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(aRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(nRuleIndex);
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSTopLevelRule getRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return null;
        }
        return this.m_aRules.get(nRuleIndex);
    }

    @Nonnull
    public EChange removeAllDeclarations() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteSupportsRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nRuleCount = this.m_aRules.size();
        if (aSettings.isRemoveUnnecessaryCode() && nRuleCount == 0) {
            return "";
        }
        StringBuilder aSB = new StringBuilder("@supports ");
        boolean bFirst = true;
        for (ICSSSupportsConditionMember aCondition : this.m_aConditionMembers) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(' ');
            }
            aSB.append(aCondition.getAsCSSString(aSettings, nIndentLevel));
        }
        if (nRuleCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}\n");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {\n");
            bFirst = true;
            for (ICSSTopLevelRule aRule : this.m_aRules) {
                String sRuleCSS = aRule.getAsCSSString(aSettings, nIndentLevel + 1);
                if (!StringHelper.hasText((String)sRuleCSS)) continue;
                if (bFirst) {
                    bFirst = false;
                } else if (!bOptimizedOutput) {
                    aSB.append('\n');
                }
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getIndent(nIndentLevel + 1));
                }
                aSB.append(sRuleCSS);
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append('\n');
            }
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSupportsRule rhs = (CSSSupportsRule)o;
        return this.m_aConditionMembers.equals(rhs.m_aConditionMembers) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aConditionMembers).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("conditionMembers", this.m_aConditionMembers).append("rules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

