/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSupportsConditionMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSupportsConditionNested
implements ICSSSupportsConditionMember,
ICSSSourceLocationAware {
    private final List<ICSSSupportsConditionMember> m_aMembers = new ArrayList<ICSSSupportsConditionMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return !this.m_aMembers.isEmpty();
    }

    @Deprecated
    @Nonnegative
    public int getSupportsMemberCount() {
        return this.getMemberCount();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        this.m_aMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSSupportsConditionNested addMember(@Nonnegative int nIndex, @Nonnull ICSSSupportsConditionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"SupportsConditionMember");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add(aMember);
        } else {
            this.m_aMembers.add(nIndex, aMember);
        }
        return this;
    }

    @Deprecated
    @Nonnull
    public EChange removeSupportsMember(@Nonnull ICSSSupportsConditionMember aMember) {
        return this.removeMember(aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSupportsConditionMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Deprecated
    @Nonnull
    public EChange removeSupportsMember(@Nonnegative int nIndex) {
        return this.removeMember(nIndex);
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Deprecated
    @Nullable
    public ICSSSupportsConditionMember getSupportsMemberAtIndex(@Nonnegative int nIndex) {
        return this.getMemberAtIndex(nIndex);
    }

    @Nullable
    public ICSSSupportsConditionMember getMemberAtIndex(@Nonnegative int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_aMembers.size()) {
            return null;
        }
        return this.m_aMembers.get(nIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSupportsConditionMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder("(");
        boolean bFirst = true;
        for (ICSSSupportsConditionMember aMember : this.m_aMembers) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(' ');
            }
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSupportsConditionNested rhs = (CSSSupportsConditionNested)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

