/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.ICSSSelectorMember;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSStyleRule
implements ICSSTopLevelRule,
IHasCSSDeclarations,
ICSSSourceLocationAware {
    private final List<CSSSelector> m_aSelectors = new ArrayList<CSSSelector>();
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasSelectors() {
        return !this.m_aSelectors.isEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aSelectors.size();
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnull CSSSelector aSelector) {
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        this.m_aSelectors.add(aSelector);
        return this;
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(nIndex, new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSStyleRule addSelector(@Nonnegative int nIndex, @Nonnull CSSSelector aSelector) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        if (nIndex >= this.getSelectorCount()) {
            this.m_aSelectors.add(aSelector);
        } else {
            this.m_aSelectors.add(nIndex, aSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector aSelector) {
        return EChange.valueOf((boolean)this.m_aSelectors.remove(aSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int nSelectorIndex) {
        if (nSelectorIndex < 0 || nSelectorIndex >= this.m_aSelectors.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aSelectors.remove(nSelectorIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllSelectors() {
        if (this.m_aSelectors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aSelectors.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int nSelectorIndex) {
        return (CSSSelector)ContainerHelper.getSafe(this.m_aSelectors, (int)nSelectorIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSelector> getAllSelectors() {
        return ContainerHelper.newList(this.m_aSelectors);
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnull @Nonempty String sProperty, @Nonnull CSSExpression aExpression, boolean bImportant) {
        this.m_aDeclarations.addDeclaration(sProperty, aExpression, bImportant);
        return this;
    }

    @Override
    @Nonnull
    public CSSStyleRule addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.addDeclaration(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        return this.m_aDeclarations.removeAllDeclarations();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnull
    public CSSStyleRule setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        this.m_aDeclarations.setDeclarationAtIndex(nIndex, aNewDeclaration);
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyName(sPropertyName);
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getDeclarationOfPropertyNameCaseInsensitive(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyName(sPropertyName);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String sPropertyName) {
        return this.m_aDeclarations.getAllDeclarationsOfPropertyNameCaseInsensitive(sPropertyName);
    }

    @Nonnull
    public String getSelectorsAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        boolean bFirst = true;
        for (CSSSelector aSelector : this.m_aSelectors) {
            if (bFirst) {
                bFirst = false;
            } else if (bOptimizedOutput) {
                aSB.append(',');
            } else {
                aSB.append(",\n").append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append(aSelector.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (aSettings.isRemoveUnnecessaryCode() && !this.hasDeclarations()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.getSelectorsAsCSSString(aSettings, nIndentLevel));
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSStyleRule rhs = (CSSStyleRule)o;
        return this.m_aSelectors.equals(rhs.m_aSelectors) && this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("selectors", this.m_aSelectors).append("declarations", (Object)this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

