/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorSimpleMember
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorSimpleMember(@Nonnull @Nonempty String sValue) {
        ValueEnforcer.notEmpty((CharSequence)sValue, (String)"Value");
        this.m_sValue = sValue;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isElementName() {
        return !this.isHash() && !this.isClass() && !this.isPseudo();
    }

    public boolean isHash() {
        return this.m_sValue.charAt(0) == '#';
    }

    public boolean isClass() {
        return this.m_sValue.charAt(0) == '.';
    }

    public boolean isPseudo() {
        return this.m_sValue.charAt(0) == ':';
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return this.m_sValue;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelectorSimpleMember rhs = (CSSSelectorSimpleMember)o;
        return this.m_sValue.equals(rhs.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

