/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.ICSSSelectorMember;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberNot
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final List<CSSSelector> m_aNestedSelectors;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberNot(@Nonnull CSSSelector aNestedSelector) {
        ValueEnforcer.notNull((Object)aNestedSelector, (String)"NestedSelector");
        this.m_aNestedSelectors = ContainerHelper.newList((Object)aNestedSelector);
    }

    public CSSSelectorMemberNot(CSSSelector ... aNestedSelectors) {
        ValueEnforcer.notNull((Object)aNestedSelectors, (String)"NestedSelectors");
        this.m_aNestedSelectors = ContainerHelper.newList((Object[])aNestedSelectors);
    }

    public CSSSelectorMemberNot(@Nonnull List<CSSSelector> aNestedSelectors) {
        ValueEnforcer.notNull(aNestedSelectors, (String)"NestedSelectors");
        this.m_aNestedSelectors = ContainerHelper.newList(aNestedSelectors);
    }

    public boolean hasSelectors() {
        return !this.m_aNestedSelectors.isEmpty();
    }

    @Nonnegative
    public int getSelectorCount() {
        return this.m_aNestedSelectors.size();
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnull CSSSelector aSelector) {
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        this.m_aNestedSelectors.add(aSelector);
        return this;
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aSingleSelectorMember) {
        ValueEnforcer.notNull((Object)aSingleSelectorMember, (String)"SingleSelectorMember");
        return this.addSelector(nIndex, new CSSSelector().addMember(aSingleSelectorMember));
    }

    @Nonnull
    public CSSSelectorMemberNot addSelector(@Nonnegative int nIndex, @Nonnull CSSSelector aSelector) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aSelector, (String)"Selector");
        if (nIndex >= this.getSelectorCount()) {
            this.m_aNestedSelectors.add(aSelector);
        } else {
            this.m_aNestedSelectors.add(nIndex, aSelector);
        }
        return this;
    }

    @Nonnull
    public EChange removeSelector(@Nonnull CSSSelector aSelector) {
        return EChange.valueOf((boolean)this.m_aNestedSelectors.remove(aSelector));
    }

    @Nonnull
    public EChange removeSelector(@Nonnegative int nSelectorIndex) {
        if (nSelectorIndex < 0 || nSelectorIndex >= this.m_aNestedSelectors.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aNestedSelectors.remove(nSelectorIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllSelectors() {
        if (this.m_aNestedSelectors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aNestedSelectors.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSSelector getSelectorAtIndex(@Nonnegative int nSelectorIndex) {
        return (CSSSelector)ContainerHelper.getSafe(this.m_aNestedSelectors, (int)nSelectorIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSSelector> getAllSelectors() {
        return ContainerHelper.newList(this.m_aNestedSelectors);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(":not(");
        boolean bFirst = true;
        for (CSSSelector aNestedSelector : this.m_aNestedSelectors) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(aNestedSelector.getAsCSSString(aSettings, 0));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelectorMemberNot rhs = (CSSSelectorMemberNot)o;
        return this.m_aNestedSelectors.equals(rhs.m_aNestedSelectors);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aNestedSelectors).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("nestedSelectors", this.m_aNestedSelectors).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

