/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberFunctionLike(@Nonnull @Nonempty String sFuncName, @Nonnull CSSExpression aParamExpr) {
        ValueEnforcer.notEmpty((CharSequence)sFuncName, (String)"FunctionName");
        if (!sFuncName.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        ValueEnforcer.notNull((Object)aParamExpr, (String)"ParameterExpression");
        this.m_sFuncName = sFuncName;
        this.m_aParamExpr = aParamExpr;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFuncName;
    }

    @Nonnull
    public CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return String.valueOf(this.m_sFuncName) + this.m_aParamExpr.getAsCSSString(aSettings, nIndentLevel) + ')';
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelectorMemberFunctionLike rhs = (CSSSelectorMemberFunctionLike)o;
        return this.m_sFuncName.equals(rhs.m_sFuncName) && this.m_aParamExpr.equals(rhs.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFuncName).append((Object)this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", (Object)this.m_sFuncName).append("paramExpr", (Object)this.m_aParamExpr).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

