/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelector
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final List<ICSSSelectorMember> m_aMembers = new ArrayList<ICSSSelectorMember>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMembers() {
        return !this.m_aMembers.isEmpty();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public CSSSelector addMember(@Nonnull ICSSSelectorMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        this.m_aMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSSelector addMember(@Nonnegative int nIndex, @Nonnull ICSSSelectorMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"Member");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add(aMember);
        } else {
            this.m_aMembers.add(nIndex, aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nMemberIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSSelectorMember getMemberAtIndex(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return null;
        }
        return this.m_aMembers.get(nMemberIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSelectorMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        for (ICSSSelectorMember aMember : this.m_aMembers) {
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSSelector rhs = (CSSSelector)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

