/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRGBA
implements ICSSWriteable {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;
    private String m_sOpacity;

    public CSSRGBA(@Nonnull CSSRGBA aOther) {
        this(aOther.getRed(), aOther.getGreen(), aOther.getBlue(), aOther.getOpacity());
    }

    public CSSRGBA(int nRed, int nGreen, int nBlue, float fOpacity) {
        this(Integer.toString(CSSColorHelper.getRGBValue(nRed)), Integer.toString(CSSColorHelper.getRGBValue(nGreen)), Integer.toString(CSSColorHelper.getRGBValue(nBlue)), Float.toString(CSSColorHelper.getOpacityToUse(fOpacity)));
    }

    public CSSRGBA(@Nonnull @Nonempty String sRed, @Nonnull @Nonempty String sGreen, @Nonnull @Nonempty String sBlue, @Nonnull @Nonempty String sOpacity) {
        this.setRed(sRed);
        this.setGreen(sGreen);
        this.setBlue(sBlue);
        this.setOpacity(sOpacity);
    }

    @Nonnull
    @Nonempty
    public String getRed() {
        return this.m_sRed;
    }

    @Nonnull
    public CSSRGBA setRed(@Nonnull @Nonempty String sRed) {
        ValueEnforcer.notEmpty((CharSequence)sRed, (String)"Red");
        this.m_sRed = sRed;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getGreen() {
        return this.m_sGreen;
    }

    @Nonnull
    public CSSRGBA setGreen(@Nonnull @Nonempty String sGreen) {
        ValueEnforcer.notEmpty((CharSequence)sGreen, (String)"Green");
        this.m_sGreen = sGreen;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBlue() {
        return this.m_sBlue;
    }

    @Nonnull
    public CSSRGBA setBlue(@Nonnull @Nonempty String sBlue) {
        ValueEnforcer.notEmpty((CharSequence)sBlue, (String)"Blue");
        this.m_sBlue = sBlue;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getOpacity() {
        return this.m_sOpacity;
    }

    @Nonnull
    public CSSRGBA setOpacity(@Nonnull @Nonempty String sOpacity) {
        ValueEnforcer.notEmpty((CharSequence)sOpacity, (String)"Opacity");
        this.m_sOpacity = sOpacity;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "rgba(" + this.m_sRed + ',' + this.m_sGreen + ',' + this.m_sBlue + ',' + this.m_sOpacity + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSRGBA rhs = (CSSRGBA)o;
        return this.m_sRed.equals(rhs.m_sRed) && this.m_sGreen.equals(rhs.m_sGreen) && this.m_sBlue.equals(rhs.m_sBlue) && this.m_sOpacity.equals(rhs.m_sOpacity);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).append((Object)this.m_sOpacity).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).append("opacity", (Object)this.m_sOpacity).toString();
    }
}

