/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSRGB
implements ICSSWriteable {
    private String m_sRed;
    private String m_sGreen;
    private String m_sBlue;

    public CSSRGB(@Nonnull CSSRGB aOther) {
        this(aOther.getRed(), aOther.getGreen(), aOther.getBlue());
    }

    public CSSRGB(int nRed, int nGreen, int nBlue) {
        this(Integer.toString(CSSColorHelper.getRGBValue(nRed)), Integer.toString(CSSColorHelper.getRGBValue(nGreen)), Integer.toString(CSSColorHelper.getRGBValue(nBlue)));
    }

    public CSSRGB(@Nonnull @Nonempty String sRed, @Nonnull @Nonempty String sGreen, @Nonnull @Nonempty String sBlue) {
        this.setRed(sRed);
        this.setGreen(sGreen);
        this.setBlue(sBlue);
    }

    @Nonnull
    @Nonempty
    public String getRed() {
        return this.m_sRed;
    }

    @Nonnull
    public CSSRGB setRed(@Nonnull @Nonempty String sRed) {
        ValueEnforcer.notEmpty((CharSequence)sRed, (String)"Red");
        this.m_sRed = sRed;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getGreen() {
        return this.m_sGreen;
    }

    @Nonnull
    public CSSRGB setGreen(@Nonnull @Nonempty String sGreen) {
        ValueEnforcer.notEmpty((CharSequence)sGreen, (String)"Green");
        this.m_sGreen = sGreen;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getBlue() {
        return this.m_sBlue;
    }

    @Nonnull
    public CSSRGB setBlue(@Nonnull @Nonempty String sBlue) {
        ValueEnforcer.notEmpty((CharSequence)sBlue, (String)"Blue");
        this.m_sBlue = sBlue;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return "rgb(" + this.m_sRed + ',' + this.m_sGreen + ',' + this.m_sBlue + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSRGB rhs = (CSSRGB)o;
        return this.m_sRed.equals(rhs.m_sRed) && this.m_sGreen.equals(rhs.m_sGreen) && this.m_sBlue.equals(rhs.m_sBlue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sRed).append((Object)this.m_sGreen).append((Object)this.m_sBlue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("red", (Object)this.m_sRed).append("green", (Object)this.m_sGreen).append("blue", (Object)this.m_sBlue).toString();
    }
}

