/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add(aMediaQuery);
        return this;
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnegative int nIndex, @Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        if (nIndex >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(aMediaQuery);
        } else {
            this.m_aMediaQueries.add(nIndex, aMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnull CSSMediaQuery aMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(aMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int nMediumIndex) {
        if (nMediumIndex < 0 || nMediumIndex >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(nMediumIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        if (this.m_aMediaQueries.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int nMediumIndex) {
        if (nMediumIndex < 0 || nMediumIndex >= this.m_aMediaQueries.size()) {
            return null;
        }
        return this.m_aMediaQueries.get(nMediumIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nonnull
    public CSSMediaRule addRule(@Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        this.m_aRules.add(aRule);
        return this;
    }

    @Nonnull
    public CSSMediaRule addRule(@Nonnegative int nIndex, @Nonnull ICSSTopLevelRule aRule) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aRule, (String)"Rule");
        if (nIndex >= this.getRuleCount()) {
            this.m_aRules.add(aRule);
        } else {
            this.m_aRules.add(nIndex, aRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule aRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(aRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(nRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllRules() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSTopLevelRule getRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return null;
        }
        return this.m_aRules.get(nRuleIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (!aSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nRuleCount = this.m_aRules.size();
        if (aSettings.isRemoveUnnecessaryCode() && nRuleCount == 0) {
            return "";
        }
        StringBuilder aSB = new StringBuilder("@media ");
        boolean bFirst = true;
        for (CSSMediaQuery sMedium : this.m_aMediaQueries) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(sMedium.getAsCSSString(aSettings, nIndentLevel));
        }
        if (nRuleCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}\n");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {\n");
            bFirst = true;
            for (ICSSTopLevelRule aRule : this.m_aRules) {
                String sRuleCSS = aRule.getAsCSSString(aSettings, nIndentLevel + 1);
                if (!StringHelper.hasText((String)sRuleCSS)) continue;
                if (bFirst) {
                    bFirst = false;
                } else if (!bOptimizedOutput) {
                    aSB.append('\n');
                }
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getIndent(nIndentLevel + 1));
                }
                aSB.append(sRuleCSS);
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append('\n');
            }
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaRule rhs = (CSSMediaRule)o;
        return this.m_aMediaQueries.equals(rhs.m_aMediaQueries) && this.m_aRules.equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

