/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaExpression;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaQuery
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final EModifier m_eModifier;
    private final String m_sMedium;
    private final List<CSSMediaExpression> m_aMediaExpressions = new ArrayList<CSSMediaExpression>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaQuery(@Nullable String sMedium) {
        this(EModifier.NONE, sMedium);
    }

    public CSSMediaQuery(@Nonnull EModifier eModifier, @Nullable String sMedium) {
        ValueEnforcer.notNull((Object)((Object)eModifier), (String)"Modifier");
        this.m_eModifier = eModifier;
        this.m_sMedium = sMedium;
    }

    @Nonnull
    public EModifier getModifier() {
        return this.m_eModifier;
    }

    public boolean isNot() {
        return this.m_eModifier == EModifier.NOT;
    }

    public boolean isOnly() {
        return this.m_eModifier == EModifier.ONLY;
    }

    @Nullable
    public String getMedium() {
        return this.m_sMedium;
    }

    public boolean hasMediaExpressions() {
        return !this.m_aMediaExpressions.isEmpty();
    }

    @Nonnegative
    public int getMediaExpressionCount() {
        return this.m_aMediaExpressions.size();
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnull CSSMediaExpression aMediaExpression) {
        ValueEnforcer.notNull((Object)aMediaExpression, (String)"MediaExpression");
        this.m_aMediaExpressions.add(aMediaExpression);
        return this;
    }

    @Nonnull
    public CSSMediaQuery addMediaExpression(@Nonnegative int nIndex, @Nonnull CSSMediaExpression aMediaExpression) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaExpression, (String)"MediaExpression");
        if (nIndex >= this.getMediaExpressionCount()) {
            this.m_aMediaExpressions.add(aMediaExpression);
        } else {
            this.m_aMediaExpressions.add(nIndex, aMediaExpression);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaExpression(@Nullable CSSMediaExpression aMediaExpression) {
        return EChange.valueOf((boolean)this.m_aMediaExpressions.remove(aMediaExpression));
    }

    @Nonnull
    public EChange removeMediaExpression(int nExpressionIndex) {
        if (nExpressionIndex < 0 || nExpressionIndex >= this.m_aMediaExpressions.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aMediaExpressions.remove(nExpressionIndex) != null ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removeAllMediaExpressions() {
        if (this.m_aMediaExpressions.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaExpressions.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSMediaExpression getMediaExpression(@Nonnegative int nExpressionIndex) {
        if (nExpressionIndex < 0 || nExpressionIndex >= this.m_aMediaExpressions.size()) {
            return null;
        }
        return this.m_aMediaExpressions.get(nExpressionIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaExpression> getAllMediaExpressions() {
        return ContainerHelper.newList(this.m_aMediaExpressions);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        aSB.append(this.m_eModifier.getCSSText());
        boolean bIsFirstExpression = true;
        if (this.m_sMedium != null) {
            aSB.append(this.m_sMedium);
            bIsFirstExpression = false;
        }
        if (!this.m_aMediaExpressions.isEmpty()) {
            for (CSSMediaExpression aMediaExpression : this.m_aMediaExpressions) {
                if (bIsFirstExpression) {
                    bIsFirstExpression = false;
                } else {
                    aSB.append(" and ");
                }
                aSB.append(aMediaExpression.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaQuery rhs = (CSSMediaQuery)o;
        return this.m_eModifier.equals((Object)rhs.m_eModifier) && EqualsUtils.equals((Object)this.m_sMedium, (Object)rhs.m_sMedium) && this.m_aMediaExpressions.equals(rhs.m_aMediaExpressions);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eModifier).append((Object)this.m_sMedium).append(this.m_aMediaExpressions).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("modifier", (Enum)this.m_eModifier).append("medium", (Object)this.m_sMedium).append("expressions", this.m_aMediaExpressions).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }

    public static enum EModifier {
        NONE(""),
        NOT("not "),
        ONLY("only ");

        private final String m_sText;

        private EModifier(String sText) {
            this.m_sText = sText;
        }

        @Nonnull
        public String getCSSText() {
            return this.m_sText;
        }
    }
}

