/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.media.ECSSMediaExpressionFeature;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaExpression
implements ICSSWriteable,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sFeature;
    private final CSSExpression m_aValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eFeature) {
        this(eFeature.getName());
    }

    public CSSMediaExpression(@Nonnull @Nonempty String sFeature) {
        this(sFeature, null);
    }

    public CSSMediaExpression(@Nonnull ECSSMediaExpressionFeature eFeature, @Nullable CSSExpression aValue) {
        this(eFeature.getName(), aValue);
    }

    public CSSMediaExpression(@Nonnull @Nonempty String sFeature, @Nullable CSSExpression aValue) {
        ValueEnforcer.notEmpty((CharSequence)sFeature, (String)"Feature");
        this.m_sFeature = sFeature;
        this.m_aValue = aValue;
    }

    @Nonnull
    @Nonempty
    public String getFeature() {
        return this.m_sFeature;
    }

    @Nullable
    public CSSExpression getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder("(").append(this.m_sFeature);
        if (this.m_aValue != null) {
            aSB.append(':').append(this.m_aValue.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSMediaExpression rhs = (CSSMediaExpression)o;
        return this.m_sFeature.equals(rhs.m_sFeature) && EqualsUtils.equals((Object)this.m_aValue, (Object)rhs.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFeature).append((Object)this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("feature", (Object)this.m_sFeature).appendIfNotNull("value", (Object)this.m_aValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

