/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final List<CSSKeyframesBlock> m_aBlocks = new ArrayList<CSSKeyframesBlock>();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String sDeclaration) {
        return StringHelper.startsWith((CharSequence)sDeclaration, (char)'@') && StringHelper.endsWithIgnoreCase((String)sDeclaration, (String)"keyframes");
    }

    public CSSKeyframesRule(@Nonnull @Nonempty String sDeclaration, @Nonnull @Nonempty String sAnimationName) {
        if (!CSSKeyframesRule.isValidDeclaration(sDeclaration)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = sDeclaration;
        this.m_sAnimationName = sAnimationName;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getAnimationName() {
        return this.m_sAnimationName;
    }

    public boolean hasBlocks() {
        return !this.m_aBlocks.isEmpty();
    }

    @Nonnegative
    public int getBlockCount() {
        return this.m_aBlocks.size();
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        ValueEnforcer.notNull((Object)aKeyframesBlock, (String)"KeyframesBlock");
        this.m_aBlocks.add(aKeyframesBlock);
        return this;
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnegative int nIndex, @Nonnull CSSKeyframesBlock aKeyframesBlock) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aKeyframesBlock, (String)"KeyframesBlock");
        if (nIndex >= this.getBlockCount()) {
            this.m_aBlocks.add(aKeyframesBlock);
        } else {
            this.m_aBlocks.add(nIndex, aKeyframesBlock);
        }
        return this;
    }

    @Nonnull
    public EChange removeBlock(@Nonnull CSSKeyframesBlock aKeyframesBlock) {
        return EChange.valueOf((boolean)this.m_aBlocks.remove(aKeyframesBlock));
    }

    @Nonnull
    public EChange removeBlock(@Nonnegative int nBlockIndex) {
        if (nBlockIndex < 0 || nBlockIndex >= this.m_aBlocks.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aBlocks.remove(nBlockIndex) != null ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removeAllBlocks() {
        if (this.m_aBlocks.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aBlocks.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSKeyframesBlock getBlockAtIndex(@Nonnegative int nBlockIndex) {
        if (nBlockIndex < 0 || nBlockIndex >= this.m_aBlocks.size()) {
            return null;
        }
        return this.m_aBlocks.get(nBlockIndex);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesBlock> getAllBlocks() {
        return ContainerHelper.newList(this.m_aBlocks);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder(this.m_sDeclaration);
        aSB.append(' ').append(this.m_sAnimationName).append(bOptimizedOutput ? "{" : " {");
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        for (CSSKeyframesBlock aBlock : this.m_aBlocks) {
            String sBlockCSS = aBlock.getAsCSSString(aSettings, nIndentLevel + 1);
            if (!StringHelper.hasText((String)sBlockCSS)) continue;
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(sBlockCSS);
            if (bOptimizedOutput) continue;
            aSB.append('\n');
        }
        if (!bOptimizedOutput) {
            aSB.append(aSettings.getIndent(nIndentLevel));
        }
        aSB.append('}');
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSKeyframesRule rhs = (CSSKeyframesRule)o;
        return this.m_sDeclaration.equals(rhs.m_sDeclaration) && this.m_sAnimationName.equals(rhs.m_sAnimationName) && this.m_aBlocks.equals(rhs.m_aBlocks);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sAnimationName).append(this.m_aBlocks).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("animationName", (Object)this.m_sAnimationName).append("blocks", this.m_aBlocks).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

