/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSURI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@Nonnull @Nonempty String sLocation) {
        this(new CSSURI(sLocation));
    }

    public CSSImportRule(@Nonnull CSSURI aLocation) {
        this.setLocation(aLocation);
    }

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnull CSSMediaQuery aMediaQuery) {
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add(aMediaQuery);
        return this;
    }

    @Nonnull
    public CSSImportRule addMediaQuery(@Nonnegative int nIndex, @Nonnull CSSMediaQuery aMediaQuery) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMediaQuery, (String)"MediaQuery");
        if (nIndex >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(aMediaQuery);
        } else {
            this.m_aMediaQueries.add(nIndex, aMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nullable CSSMediaQuery aMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(aMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(int nMediumIndex) {
        if (nMediumIndex < 0 || nMediumIndex >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(nMediumIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        if (this.m_aMediaQueries.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    @Nonnull
    public CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonnull
    @Nonempty
    public String getLocationString() {
        return this.m_aLocation.getURI();
    }

    @Nonnull
    public CSSImportRule setLocation(@Nonnull CSSURI aLocation) {
        ValueEnforcer.notNull((Object)aLocation, (String)"Location");
        this.m_aLocation = aLocation;
        return this;
    }

    @Nonnull
    public CSSImportRule setLocationString(@Nonnull @Nonempty String sLocationURI) {
        this.m_aLocation.setURI(sLocationURI);
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        aSB.append("@import ").append(this.m_aLocation.getAsCSSString(aSettings, nIndentLevel));
        if (!this.m_aMediaQueries.isEmpty()) {
            aSB.append(' ');
            boolean bFirst = true;
            for (CSSMediaQuery aMediaQuery : this.m_aMediaQueries) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    aSB.append(bOptimizedOutput ? "," : ", ");
                }
                aSB.append(aMediaQuery.getAsCSSString(aSettings, nIndentLevel));
            }
        }
        return aSB.append(";\n").toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSImportRule rhs = (CSSImportRule)o;
        return this.m_aLocation.equals(rhs.m_aLocation) && this.m_aMediaQueries.equals(rhs.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

