/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.utils.CSSColorHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSHSL
implements ICSSWriteable,
ICSSVersionAware {
    private String m_sHue;
    private String m_sSaturation;
    private String m_sLightness;

    public CSSHSL(@Nonnull CSSHSL aOther) {
        this(aOther.getHue(), aOther.getSaturation(), aOther.getLightness());
    }

    public CSSHSL(int nHue, int nSaturation, int nLightness) {
        this(Integer.toString(CSSColorHelper.getHSLHueValue(nHue)), String.valueOf(Integer.toString(CSSColorHelper.getHSLPercentageValue(nSaturation))) + "%", String.valueOf(Integer.toString(CSSColorHelper.getHSLPercentageValue(nLightness))) + "%");
    }

    public CSSHSL(float fHue, float fSaturation, float fLightness) {
        this(Float.toString(CSSColorHelper.getHSLHueValue(fHue)), String.valueOf(Float.toString(CSSColorHelper.getHSLPercentageValue(fSaturation))) + "%", String.valueOf(Float.toString(CSSColorHelper.getHSLPercentageValue(fLightness))) + "%");
    }

    public CSSHSL(@Nonnull @Nonempty String sHue, @Nonnull @Nonempty String sSaturation, @Nonnull @Nonempty String sLightness) {
        this.setHue(sHue);
        this.setSaturation(sSaturation);
        this.setLightness(sLightness);
    }

    @Nonnull
    @Nonempty
    public String getHue() {
        return this.m_sHue;
    }

    @Nonnull
    public CSSHSL setHue(@Nonnull @Nonempty String sHue) {
        ValueEnforcer.notEmpty((CharSequence)sHue, (String)"Hue");
        this.m_sHue = sHue;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getSaturation() {
        return this.m_sSaturation;
    }

    @Nonnull
    public CSSHSL setSaturation(@Nonnull @Nonempty String sSaturation) {
        ValueEnforcer.notEmpty((CharSequence)sSaturation, (String)"Saturation");
        this.m_sSaturation = sSaturation;
        return this;
    }

    @Nonnull
    @Nonempty
    public String getLightness() {
        return this.m_sLightness;
    }

    @Nonnull
    public CSSHSL setLightness(@Nonnull @Nonempty String sLightness) {
        ValueEnforcer.notEmpty((CharSequence)sLightness, (String)"Lightness");
        this.m_sLightness = sLightness;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return "hsl(" + this.m_sHue + ',' + this.m_sSaturation + ',' + this.m_sLightness + ")";
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSHSL rhs = (CSSHSL)o;
        return this.m_sHue.equals(rhs.m_sHue) && this.m_sSaturation.equals(rhs.m_sSaturation) && this.m_sLightness.equals(rhs.m_sLightness);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sHue).append((Object)this.m_sSaturation).append((Object)this.m_sLightness).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("hue", (Object)this.m_sHue).append("saturation", (Object)this.m_sSaturation).append("lightness", (Object)this.m_sLightness).toString();
    }
}

