/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSURI;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberTermURI
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private CSSURI m_aURI;

    public CSSExpressionMemberTermURI(@Nonnull @Nonempty String sURIString) {
        this(new CSSURI(sURIString));
    }

    public CSSExpressionMemberTermURI(@Nonnull CSSURI aURI) {
        this.setURI(aURI);
    }

    @Nonnull
    public CSSURI getURI() {
        return this.m_aURI;
    }

    @Nonnull
    @Nonempty
    public String getURIString() {
        return this.m_aURI.getURI();
    }

    @Nonnull
    public CSSExpressionMemberTermURI setURI(@Nonnull CSSURI aURI) {
        this.m_aURI = (CSSURI)ValueEnforcer.notNull((Object)aURI, (String)"URI");
        return this;
    }

    @Nonnull
    public CSSExpressionMemberTermURI setURIString(@Nonnull @Nonempty String sURIString) {
        this.m_aURI.setURI(sURIString);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberTermURI getClone() {
        return new CSSExpressionMemberTermURI(this.m_aURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return this.m_aURI.getAsCSSString(aSettings, nIndentLevel);
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aURI.setSourceLocation(aSourceLocation);
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aURI.getSourceLocation();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberTermURI rhs = (CSSExpressionMemberTermURI)o;
        return this.m_aURI.equals(rhs.m_aURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("URI", (Object)this.m_aURI).toString();
    }
}

