/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpressionTermOptimizer;
import com.phloc.css.decl.ICSSExpressionMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberTermSimple
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private String m_sValue;
    private String m_sOptimizedValue;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberTermSimple(int nValue) {
        this(Integer.toString(nValue));
    }

    public CSSExpressionMemberTermSimple(long nValue) {
        this(Long.toString(nValue));
    }

    public CSSExpressionMemberTermSimple(float fValue) {
        this(Float.toString(fValue));
    }

    public CSSExpressionMemberTermSimple(double dValue) {
        this(Double.toString(dValue));
    }

    public CSSExpressionMemberTermSimple(@Nonnull @Nonempty String sValue) {
        this.setValue(sValue);
    }

    @Nonnull
    public CSSExpressionMemberTermSimple setValue(@Nonnull @Nonempty String sValue) {
        ValueEnforcer.notEmpty((CharSequence)sValue, (String)"Value");
        this.m_sValue = sValue;
        this.m_sOptimizedValue = CSSExpressionTermOptimizer.getOptimizedValue(sValue);
        return this;
    }

    @Nonnull
    @Nonempty
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    @Nonempty
    public String getOptimizedValue() {
        return this.m_sOptimizedValue;
    }

    @Nonnull
    public CSSExpressionMemberTermSimple getClone() {
        return new CSSExpressionMemberTermSimple(this.m_sValue);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return aSettings.isOptimizedOutput() ? this.m_sOptimizedValue : this.m_sValue;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberTermSimple rhs = (CSSExpressionMemberTermSimple)o;
        return this.m_sOptimizedValue.equals(rhs.m_sOptimizedValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sOptimizedValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", (Object)this.m_sValue).append("optimizedValue", (Object)this.m_sOptimizedValue).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

