/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSUnit;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMathUnitSimple
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final String m_sText;
    private final ECSSUnit m_eUnit;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMathUnitSimple(@Nonnull @Nonempty String sText) {
        if (StringHelper.hasNoTextAfterTrim((String)sText)) {
            throw new IllegalArgumentException("text");
        }
        this.m_sText = sText.trim();
        this.m_eUnit = CSSNumberHelper.getMatchingUnitExclPercentage(this.m_sText);
    }

    @Nonnull
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        return this.m_sText;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitSimple rhs = (CSSExpressionMemberMathUnitSimple)o;
        return this.m_sText.equals(rhs.m_sText);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("text", (Object)this.m_sText).append("unit", (Enum)this.m_eUnit).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

