/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpressionMemberMathProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final List<ICSSExpressionMathMember> m_aMembers = new ArrayList<ICSSExpressionMathMember>();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpressionMemberMathProduct addMember(@Nonnull ICSSExpressionMathMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMathMember");
        this.m_aMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberMathProduct addMember(@Nonnegative int nIndex, @Nonnull ICSSExpressionMathMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMathMember");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add(aMember);
        } else {
            this.m_aMembers.add(nIndex, aMember);
        }
        return this;
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSExpressionMathMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nMemberIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMathMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        StringBuilder aSB = new StringBuilder();
        for (ICSSExpressionMathMember aMember : this.m_aMembers) {
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpressionMemberMathProduct rhs = (CSSExpressionMemberMathProduct)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

