/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.ECSSExpressionOperator;
import com.phloc.css.decl.ICSSExpressionMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSExpression
implements ICSSWriteable,
ICSSSourceLocationAware {
    private final List<ICSSExpressionMember> m_aMembers = new ArrayList<ICSSExpressionMember>();
    private CSSSourceLocation m_aSourceLocation;

    @Nonnull
    public CSSExpression addMember(@Nonnull ICSSExpressionMember aMember) {
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMember");
        this.m_aMembers.add(aMember);
        return this;
    }

    @Nonnull
    public CSSExpression addMember(@Nonnegative int nIndex, @Nonnull ICSSExpressionMember aMember) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aMember, (String)"ExpressionMember");
        if (nIndex >= this.getMemberCount()) {
            this.m_aMembers.add(aMember);
        } else {
            this.m_aMembers.add(nIndex, aMember);
        }
        return this;
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnull @Nonempty String sValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(sValue));
    }

    @Nonnull
    public CSSExpression addTermSimple(@Nonnegative int nIndex, @Nonnull @Nonempty String sValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(sValue));
    }

    @Nonnull
    public CSSExpression addNumber(int nValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, int nValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(long nValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, long nValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(nValue));
    }

    @Nonnull
    public CSSExpression addNumber(float fValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(fValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, float fValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(fValue));
    }

    @Nonnull
    public CSSExpression addNumber(double dValue) {
        return this.addMember(new CSSExpressionMemberTermSimple(dValue));
    }

    @Nonnull
    public CSSExpression addNumber(@Nonnegative int nIndex, double dValue) {
        return this.addMember(nIndex, new CSSExpressionMemberTermSimple(dValue));
    }

    @Nonnull
    @Nonempty
    private static String _createStringValue(@Nonnull String sValue) {
        return String.valueOf('\"') + StringHelper.replaceAll((String)sValue, (String)"\"", (CharSequence)"\\\"") + '\"';
    }

    @Nonnull
    public CSSExpression addString(@Nonnull String sValue) {
        return this.addTermSimple(CSSExpression._createStringValue(sValue));
    }

    @Nonnull
    public CSSExpression addString(@Nonnegative int nIndex, @Nonnull String sValue) {
        return this.addTermSimple(nIndex, CSSExpression._createStringValue(sValue));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnull @Nonempty String sURI) {
        return this.addMember(new CSSExpressionMemberTermURI(sURI));
    }

    @Nonnull
    public CSSExpression addURI(@Nonnegative int nIndex, @Nonnull @Nonempty String sURI) {
        return this.addMember(nIndex, new CSSExpressionMemberTermURI(sURI));
    }

    @Nonnull
    public EChange removeMember(@Nullable ICSSExpressionMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nMemberIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMembers() {
        if (this.m_aMembers.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSExpressionMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Nullable
    public ICSSExpressionMember getMemberAtIndex(@Nonnegative int nIndex) {
        return (ICSSExpressionMember)ContainerHelper.getSafe(this.m_aMembers, (int)nIndex);
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Nonnull
    public List<CSSExpressionMemberTermSimple> getAllSimpleMembers() {
        ArrayList<CSSExpressionMemberTermSimple> ret = new ArrayList<CSSExpressionMemberTermSimple>();
        for (ICSSExpressionMember aMember : this.m_aMembers) {
            if (!(aMember instanceof CSSExpressionMemberTermSimple)) continue;
            ret.add((CSSExpressionMemberTermSimple)aMember);
        }
        return ret;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        boolean bPrevWasOperator = false;
        for (ICSSExpressionMember aMember : this.m_aMembers) {
            boolean bIsOp = aMember instanceof ECSSExpressionOperator;
            if (!bIsOp && !bPrevWasOperator && aSB.length() > 0) {
                aSB.append(' ');
            }
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
            bPrevWasOperator = bIsOp;
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSExpression rhs = (CSSExpression)o;
        return this.m_aMembers.equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("members", this.m_aMembers).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }

    @Nonnull
    public static CSSExpression createSimple(@Nonnull @Nonempty String sValue) {
        return new CSSExpression().addTermSimple(sValue);
    }

    @Nonnull
    public static CSSExpression createString(@Nonnull @Nonempty String sValue) {
        return new CSSExpression().addString(sValue);
    }

    @Nonnull
    public static CSSExpression createNumber(int nValue) {
        return new CSSExpression().addNumber(nValue);
    }

    @Nonnull
    public static CSSExpression createNumber(long nValue) {
        return new CSSExpression().addNumber(nValue);
    }

    @Nonnull
    public static CSSExpression createNumber(float fValue) {
        return new CSSExpression().addNumber(fValue);
    }

    @Nonnull
    public static CSSExpression createNumber(double dValue) {
        return new CSSExpression().addNumber(dValue);
    }

    @Nonnull
    public static CSSExpression createURI(@Nonnull @Nonempty String sURI) {
        return new CSSExpression().addURI(sURI);
    }
}

