/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclarationList
implements IHasCSSDeclarations,
ICSSSourceLocationAware {
    private final List<CSSDeclaration> m_aDeclarations = new ArrayList<CSSDeclaration>();
    private CSSSourceLocation m_aSourceLocation;

    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull CSSDeclaration aNewDeclaration) {
        ValueEnforcer.notNull((Object)aNewDeclaration, (String)"NewDeclaration");
        this.m_aDeclarations.add(aNewDeclaration);
        return this;
    }

    @Override
    @Nonnull
    public final CSSDeclarationList addDeclaration(@Nonnull @Nonempty String sProperty, @Nonnull CSSExpression aExpression, boolean bImportant) {
        return this.addDeclaration(new CSSDeclaration(sProperty, aExpression, bImportant));
    }

    @Override
    @Nonnull
    public CSSDeclarationList addDeclaration(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aNewDeclaration, (String)"NewDeclaration");
        if (nIndex >= this.getDeclarationCount()) {
            this.m_aDeclarations.add(aNewDeclaration);
        } else {
            this.m_aDeclarations.add(nIndex, aNewDeclaration);
        }
        return this;
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return EChange.valueOf((boolean)this.m_aDeclarations.remove(aDeclaration));
    }

    @Override
    @Nonnull
    public final EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        if (nDeclarationIndex < 0 || nDeclarationIndex >= this.m_aDeclarations.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aDeclarations.remove(nDeclarationIndex) != null ? 1 : 0) != 0);
    }

    @Override
    @Nonnull
    public EChange removeAllDeclarations() {
        if (this.m_aDeclarations.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aDeclarations.clear();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<CSSDeclaration> getAllDeclarations() {
        return ContainerHelper.newList(this.m_aDeclarations);
    }

    @Override
    @Nullable
    public final CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return (CSSDeclaration)ContainerHelper.getSafe(this.m_aDeclarations, (int)nIndex);
    }

    @Override
    @Nonnull
    public CSSDeclarationList setDeclarationAtIndex(@Nonnegative int nIndex, @Nonnull CSSDeclaration aNewDeclaration) {
        ValueEnforcer.isGE0((int)nIndex, (String)"Index");
        ValueEnforcer.notNull((Object)aNewDeclaration, (String)"NewDeclaration");
        if (nIndex >= this.getDeclarationCount()) {
            this.m_aDeclarations.add(aNewDeclaration);
        } else {
            this.m_aDeclarations.set(nIndex, aNewDeclaration);
        }
        return this;
    }

    @Override
    public boolean hasDeclarations() {
        return !this.m_aDeclarations.isEmpty();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.size();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyName(@Nullable String sPropertyName) {
        if (StringHelper.hasText((String)sPropertyName)) {
            for (CSSDeclaration aDecl : this.m_aDeclarations) {
                if (!aDecl.getProperty().equals(sPropertyName)) continue;
                return aDecl;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationOfPropertyNameCaseInsensitive(@Nullable String sPropertyName) {
        if (StringHelper.hasText((String)sPropertyName)) {
            for (CSSDeclaration aDecl : this.m_aDeclarations) {
                if (!aDecl.getProperty().equalsIgnoreCase(sPropertyName)) continue;
                return aDecl;
            }
        }
        return null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyName(@Nullable String sPropertyName) {
        ArrayList<CSSDeclaration> ret = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)sPropertyName)) {
            for (CSSDeclaration aDecl : this.m_aDeclarations) {
                if (!aDecl.getProperty().equals(sPropertyName)) continue;
                ret.add(aDecl);
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarationsOfPropertyNameCaseInsensitive(@Nullable String sPropertyName) {
        ArrayList<CSSDeclaration> ret = new ArrayList<CSSDeclaration>();
        if (StringHelper.hasText((String)sPropertyName)) {
            for (CSSDeclaration aDecl : this.m_aDeclarations) {
                if (!aDecl.getProperty().equalsIgnoreCase(sPropertyName)) continue;
                ret.add(aDecl);
            }
        }
        return ret;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nDeclCount = this.m_aDeclarations.size();
        if (nDeclCount == 0) {
            return "";
        }
        if (nDeclCount == 1) {
            StringBuilder aSB = new StringBuilder();
            aSB.append(((CSSDeclaration)ContainerHelper.getFirstElement(this.m_aDeclarations)).getAsCSSString(aSettings, nIndentLevel));
            if (!bOptimizedOutput) {
                aSB.append(';');
            }
            return aSB.toString();
        }
        StringBuilder aSB = new StringBuilder();
        int nIndex = 0;
        for (CSSDeclaration aDeclaration : this.m_aDeclarations) {
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel + 1));
            }
            aSB.append(aDeclaration.getAsCSSString(aSettings, nIndentLevel + 1));
            if (!bOptimizedOutput || nIndex < nDeclCount - 1) {
                aSB.append(';');
            }
            if (!bOptimizedOutput) {
                aSB.append('\n');
            }
            ++nIndex;
        }
        return aSB.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSDeclarationList rhs = (CSSDeclarationList)o;
        return this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", this.m_aDeclarations).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

