/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.CSSSourceLocation;
import com.phloc.css.ICSSSourceLocationAware;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.property.ECSSProperty;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSDeclaration
implements ICSSWriteable,
ICSSSourceLocationAware {
    public static final boolean DEFAULT_IMPORTANT = false;
    private String m_sProperty;
    private CSSExpression m_aExpression;
    private boolean m_bIsImportant;
    private CSSSourceLocation m_aSourceLocation;

    public CSSDeclaration(@Nonnull @Nonempty String sProperty, @Nonnull CSSExpression aExpression) {
        this(sProperty, aExpression, false);
    }

    public CSSDeclaration(@Nonnull @Nonempty String sProperty, @Nonnull CSSExpression aExpression, boolean bIsImportant) {
        this.setProperty(sProperty);
        this.setExpression(aExpression);
        this.setImportant(bIsImportant);
    }

    @Nonnull
    @Nonempty
    public String getProperty() {
        return this.m_sProperty;
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull @Nonempty String sProperty) {
        this.m_sProperty = ((String)ValueEnforcer.notEmpty((CharSequence)sProperty, (String)"Property")).toLowerCase(Locale.US);
        return this;
    }

    @Nonnull
    public CSSDeclaration setProperty(@Nonnull ECSSProperty eProperty) {
        ValueEnforcer.notNull((Object)eProperty, (String)"Property");
        return this.setProperty(eProperty.getName());
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public CSSExpression getExpression() {
        return this.m_aExpression;
    }

    @Nonnull
    public CSSDeclaration setExpression(@Nonnull CSSExpression aExpression) {
        this.m_aExpression = (CSSExpression)ValueEnforcer.notNull((Object)aExpression, (String)"Expression");
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSDeclaration setImportant(boolean bIsImportant) {
        this.m_bIsImportant = bIsImportant;
        return this;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        return String.valueOf(this.m_sProperty) + ':' + this.m_aExpression.getAsCSSString(aSettings, nIndentLevel) + (this.m_bIsImportant ? " !important" : "");
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation aSourceLocation) {
        this.m_aSourceLocation = aSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        CSSDeclaration rhs = (CSSDeclaration)o;
        return this.m_sProperty.equals(rhs.m_sProperty) && this.m_aExpression.equals(rhs.m_aExpression) && this.m_bIsImportant == rhs.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sProperty).append((Object)this.m_aExpression).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_sProperty).append("expression", (Object)this.m_aExpression).append("important", this.m_bIsImportant).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

