/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.id.IHasID;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.css.ECSSSpecificationStatus;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSSpecification implements IHasID<String>
{
    CSS3_COLOR("css3-color", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-color-20110607/"),
    CSS3_NAMESPACE("css3-namespace", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-namespace-20110929/"),
    SELECTORS("selectors", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2011/REC-css3-selectors-20110929/"),
    CSS2("CSS2", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/CSS2/"),
    CSS1("CSS1", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/CSS1/"),
    CSS_PRINT("css-print", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2013/NOTE-css-print-20130314/"),
    CSS3_MEDIAQUERIES("css3-mediaqueries", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2012/REC-css3-mediaqueries-20120619/"),
    CSS_STYLE_ATTR("css-style-attr", ECSSSpecificationStatus.COMPLETED, "http://www.w3.org/TR/2013/REC-css-style-attr-20131107/"),
    CSS3_BACKGROUND("css3-background", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-background-20120724/"),
    CSS3_CONDITIONAL("css3-conditional", ECSSSpecificationStatus.TESTING),
    CSS3_IMAGES("css3-images", ECSSSpecificationStatus.TESTING),
    CSS3_MARQUEE("css3-marquee", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2008/CR-css3-marquee-20081205/"),
    CSS3_MULTICOL("css3-multicol", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2011/CR-css3-multicol-20110412/"),
    CSS3_SPEECH("css3-speech", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-speech-20120320/"),
    CSS3_VALUES("css3-values", ECSSSpecificationStatus.TESTING),
    CSS3_FLEXBOX("css3-flexbox", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2012/CR-css3-flexbox-20120918/"),
    CSS_TEXT_DECOR_3("css-text-decor-3", ECSSSpecificationStatus.TESTING),
    CSS3_CASCADE("css3-cascade", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css-cascade-3-20131003/"),
    CSS3_FONTS("css3-fonts", ECSSSpecificationStatus.TESTING, "http://www.w3.org/TR/2013/CR-css-fonts-3-20131003/"),
    CSS_MOBILE("css-mobile", ECSSSpecificationStatus.TESTING),
    CSS_TV("css-tv", ECSSSpecificationStatus.TESTING),
    CSS3_ANIMATIONS("css3-animations", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css3-animations-20130219/"),
    CSS_COUNTER_STYLES_3("css-counter-styles-3", ECSSSpecificationStatus.REFINING),
    CSS_MASKING("css-masking", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css-masking-1-20131029/"),
    CSS3_TEXT("css3-text", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2012/WD-css3-text-20121113/"),
    CSS3_BREAK("css3-break", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2012/WD-css3-break-20120823/"),
    CSS_SHAPES("css-shapes-1", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css-shapes-1-20131203/"),
    CSS3_TRANSFORMS("css3-transforms", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2012/WD-css3-transforms-20120911/"),
    CSS3_TRANSITIONS("css3-transitions", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-css3-transitions-20130212/"),
    CSS_VARIABLES("css-variables", ECSSSpecificationStatus.REFINING),
    CSS3_WRITING_MODES("css3-writing-modes", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2012/WD-css3-writing-modes-20121115/"),
    COMPOSITING("compositing", ECSSSpecificationStatus.REFINING, "http://www.w3.org/TR/2013/WD-compositing-1-20131010/"),
    CSS3_ALIGN("css3-align", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-css3-align-20130514/"),
    CSS3_GRID_LAYOUT("css3-grid-layout", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2013/WD-css3-grid-layout-20130910/"),
    CSS3_PAGE("css3-page", ECSSSpecificationStatus.REVISING),
    CSS3_SYNTAX("css3-syntax", ECSSSpecificationStatus.REVISING),
    CSS3_UI("css3-ui", ECSSSpecificationStatus.REVISING, "http://www.w3.org/TR/2012/WD-css3-ui-20120117/"),
    CSSOM_VIEW("cssom-view", ECSSSpecificationStatus.REVISING),
    SELECTORS4("selectors4", ECSSSpecificationStatus.REVISING),
    CSS4_BACKGROUND("css4-background", ECSSSpecificationStatus.EXPLORING),
    CSS_DEVICE_ADAPT("css-device-adapt", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2011/WD-css-device-adapt-20110915/"),
    CSS3_EXCLUSIONS("css3-exclusions", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css3-exclusions-20130528/"),
    FILTER_EFFECTS("filter-effects", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-filter-effects-20130523/"),
    CSS3_GCPM("css3-gpcm", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2011/WD-css3-gcpm-20111129/"),
    CSS3_LAYOUT("css3-layout", ECSSSpecificationStatus.EXPLORING),
    CSS3_SIZING("css3-sizing", ECSSSpecificationStatus.EXPLORING),
    CSS_LINE_GRID("css-line-grid", ECSSSpecificationStatus.EXPLORING),
    CSS3_LISTS("css3-lists", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2011/WD-css3-lists-20110524/"),
    CSS3_POSITIONING("css3-positioning", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2012/WD-css3-positioning-20120207/"),
    CSS3_PRESLEV("css3-preslev", ECSSSpecificationStatus.EXPLORING),
    CSS3_REGIONS("css3-regions", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css3-regions-20130528/"),
    CSS3_RUBY("css3-ruby", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css3-ruby-20130919/"),
    CSS3_TABLES("css3-tables", ECSSSpecificationStatus.EXPLORING),
    CSSOM("cssom", ECSSSpecificationStatus.EXPLORING),
    CSS_OVERFLOW_3("css-overflow-3", ECSSSpecificationStatus.EXPLORING, "http://www.w3.org/TR/2013/WD-css-overflow-3-20130418/"),
    CSS3_BOX("css3-box", ECSSSpecificationStatus.REWRITING),
    CSS3_CONTENT("css3-content", ECSSSpecificationStatus.REWRITING, "http://www.w3.org/TR/2003/WD-css3-content-20030514/"),
    CSS3_LINEBOX("css3-linebox", ECSSSpecificationStatus.REWRITING, "http://www.w3.org/TR/2002/WD-css3-linebox-20020515/"),
    BECSS("becss", ECSSSpecificationStatus.ABANDONED),
    CSS3_HYPERLINKS("css3-hyperlinks", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2004/WD-css3-hyperlinks-20040224/"),
    CSS3_GRID("css3-grid", ECSSSpecificationStatus.ABANDONED, "http://www.w3.org/TR/2007/WD-css3-grid-20070905/");

    private final String m_sID;
    private final ECSSSpecificationStatus m_eStatus;
    private final String m_sHandledURL;

    private ECSSSpecification(String sID, ECSSSpecificationStatus eStatus) {
        this(sID, eStatus, null);
    }

    private ECSSSpecification(@Nullable String sID, ECSSSpecificationStatus eStatus, String sHandledURL) {
        this.m_sID = sID;
        this.m_eStatus = eStatus;
        this.m_sHandledURL = sHandledURL;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public ECSSSpecificationStatus getStatus() {
        return this.m_eStatus;
    }

    public boolean hasHandledURL() {
        return StringHelper.hasText((String)this.m_sHandledURL);
    }

    @Nullable
    public String getHandledURL() {
        return this.m_sHandledURL;
    }

    @Nullable
    public static ECSSSpecification getFromIDOrNull(@Nullable String sName) {
        return (ECSSSpecification)EnumHelper.getFromIDOrNull(ECSSSpecification.class, (Object)sName);
    }
}

