/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.validator;

import com.aptana.core.IFilter;
import com.aptana.core.build.AbstractBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.index.core.build.BuildContext;
import com.phloc.css.ECSSVersion;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.parser.ParseException;
import com.phloc.css.reader.CSSReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;

public class PhlocCssValidator
extends AbstractBuildParticipant {
    public static final String ID = "com.aptana.editor.css.validator.PhlocCssValidator";

    public void initContext(BuildContext context) {
        List problems = Collections.emptyList();
        context.putProblems("com.aptana.editor.css.phloccss_problem", problems);
    }

    public void buildFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        List<Object> problems = Collections.emptyList();
        String sourcePath = context.getURI().toString();
        try {
            problems = this.parseWithPhlocCss(context.getContents(), sourcePath, monitor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (String)MessageFormat.format("Failed to parse {0} with Phloc-Css", sourcePath), (Throwable)e);
        }
        context.putProblems("com.aptana.editor.css.phloccss_problem", problems);
    }

    public void deleteFile(BuildContext context, IProgressMonitor monitor) {
        if (context == null) {
            return;
        }
        context.removeProblems("com.aptana.editor.css.phloccss_problem");
    }

    protected List<IProblem> parseWithPhlocCss(String source, final String path, IProgressMonitor monitor) {
        final ArrayList problems = new ArrayList();
        CSSReader.setDefaultParseExceptionHandler(new ICSSParseExceptionHandler(){

            public void onException(ParseException ex) {
                problems.add(PhlocCssValidator.this.createError(ex.getMessage(), ex.errorTokenBeginLine, ex.errorTokenBeginColumn, ex.errorTokenLength, path));
            }
        });
        long start = System.currentTimeMillis();
        CSSReader.readFromString(source, Charset.forName("utf-8"), ECSSVersion.CSS30);
        IdeLog.logInfo((Plugin)CSSPlugin.getDefault(), (String)("css\u9a8c\u8bc1\u8017\u65f6: " + (System.currentTimeMillis() - start)));
        final List filters = this.getFilters();
        List result = CollectionsUtil.filter(problems, (IFilter)new IFilter<IProblem>(){

            public boolean include(IProblem item) {
                return !PhlocCssValidator.this.isIgnored(item.getMessage(), filters);
            }
        });
        Document doc = new Document(source);
        for (IProblem problem : problems) {
            try {
                IRegion lineInfo = doc.getLineInformation(problem.getLineNumber() - 1);
                int realOffset = lineInfo.getOffset();
                String rawLine = doc.get(realOffset, lineInfo.getLength());
                int lineLength = rawLine.length();
                int actual = problem.getOffset() - 1;
                int x = 0;
                while (x < actual) {
                    if (lineLength <= x) break;
                    ++realOffset;
                    ++x;
                }
                if (!(problem instanceof Problem)) continue;
                ((Problem)problem).setOffset(realOffset);
            }
            catch (BadLocationException badLocationException) {}
        }
        return result;
    }
}

