/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing.ast;

import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSTextNode;
import com.aptana.editor.css.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.Arrays;
import java.util.List;

public class CSSKeyFramesNode
extends CSSNode {
    private String keyframes = "@keyframes";
    private CSSTextNode animationName;
    private String fText;

    public CSSKeyFramesNode(String keyframe, CSSTextNode name, CSSNode ... statements) {
        this.keyframes = keyframe;
        this.animationName = name;
        this.setChildren((IParseNode[])statements);
    }

    @Override
    public short getNodeType() {
        return 22;
    }

    @Override
    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof CSSKeyFramesNode)) {
            return false;
        }
        CSSKeyFramesNode other = (CSSKeyFramesNode)((Object)obj);
        return this.toString().equals(other.toString());
    }

    public CSSTextNode getAnimationName() {
        return this.animationName;
    }

    public CSSNode[] getStatements() {
        List<IParseNode> list = Arrays.asList(this.getChildren());
        return list.toArray(new CSSNode[list.size()]);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(this.keyframes);
        text.append(' ').append((Object)this.animationName);
        return text.toString();
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.toString().hashCode();
    }

    public String toString() {
        if (this.fText == null) {
            CSSNode[] statements;
            StringBuilder text = new StringBuilder();
            text.append(this.keyframes);
            text.append(' ').append((Object)this.animationName);
            text.append('{');
            CSSNode[] cSSNodeArray = statements = this.getStatements();
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                CSSNode statement = cSSNodeArray[n2];
                text.append((Object)statement);
                ++n2;
            }
            text.append('}');
            this.fText = text.toString();
        }
        return this.fText;
    }
}

