/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.parsing;

import beaver.Parser;
import beaver.ParsingTables;
import beaver.Scanner;
import beaver.Symbol;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.parsing.CSSFlexScanner;
import com.aptana.editor.css.parsing.ast.CSSAtRuleNode;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSCharSetNode;
import com.aptana.editor.css.parsing.ast.CSSCommentNode;
import com.aptana.editor.css.parsing.ast.CSSDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSErrorDeclarationNode;
import com.aptana.editor.css.parsing.ast.CSSErrorExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSFontFaceNode;
import com.aptana.editor.css.parsing.ast.CSSFunctionNode;
import com.aptana.editor.css.parsing.ast.CSSIEExpressionNode;
import com.aptana.editor.css.parsing.ast.CSSImportNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesNode;
import com.aptana.editor.css.parsing.ast.CSSList;
import com.aptana.editor.css.parsing.ast.CSSMediaNode;
import com.aptana.editor.css.parsing.ast.CSSMozDocument;
import com.aptana.editor.css.parsing.ast.CSSNamespaceNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSPageNode;
import com.aptana.editor.css.parsing.ast.CSSPageSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSParseRootNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSSimpleSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSTermListNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.editor.css.parsing.ast.CSSTextNode;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.WorkingParseResult;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseError;
import com.aptana.parsing.ast.ParseRootNode;
import com.aptana.parsing.util.ParseUtil;
import java.util.ArrayList;
import java.util.List;

public class CSSParser
extends Parser
implements IParser {
    static final ParsingTables PARSING_TABLES = new ParsingTables("U9pjMNTy5KKNFVEAcY0AA11C4KnY0nKGAmYe28Y22SqGIWGqG4W0GySM6mgYDBlO5SNU4Em8zjvxxBq2YXWizpjJthvzoRwNuDVumytllBdtpfrpxypEpCvkWEXyj4G6if2DriX7PsoFdT06hP27NR4RTiSUs1DjKOaTCG05w8zCv61dx8SEoCKkw8W3iIywuJHCHtkqmrxO0NjZ7#oF0t0G3axWrZv1t1UZ2$yEuLymzoRSwBYR9#DMEwdCGEvDs82VqOJz2kRkZcwEkrdIl5lmBv1R0N#X3yuDvbPvEDfogyIyzJWSmSn#nmqu7XFmkWhXEhKrkaWHny3QNyOhU5M5rFPOWaOuGUseTiL4H135LjWQso0DwTWMZJ4P9o74kpEJTsS6xyx9XhslTCGTk1DtunwyXdln41x36ZoDPRW5j#8st8wxi08hyG0UnFDu0I$Y9Gndks6gAKPWaCdgT9ME4Wp4O1oB8Wn1COPY94PXD0fn7Dx0ctWBR#CTbE4CZ4S5ng7SSk0SZwCVvgJWi3qTWxdakBuMntoFuq9SL2$7YRWaWEDIZ#DoN962urgLozapJMMGOsajZliyZkMuFmN7mrYbMgisQXToF56BuncFurJLCWN7kvZiSNnOY#DZZ#CirIe5ntlu1E$ZKNn6ZizhSNpgSNoF7rDmL6AjQeRLWHphFOvVE5R9EPRYJmYUObccMYHogAmOXpmgZoJda8Tb3O3dc4#Psg5M7l3oq5TI3guglHwcn5URIlDM5SogGi2gqjTXcnVf7#yjsTlD0$XsNVZd0S91yu2jx6LR7OMpwxGwicuh#GiRsQOIrToJnt9FteYRyHkrOmZDeRMRVNlsRDo43r3ADhrGenePJUCFrA07jgFz0Yoc1gmZkk8ojGsQgdmH4mTaPT#OQvLXjhdECZQJgsfYC#UbMO6UH0qp1xx33$Y9p1jDd6eJ1sfRm#F5CIs$y3W#mg6E1yoy1b$YAqhpY4IUM4$zFBCHknOIXnkUh$4DlYMFlcoCH1wTPo9FjV7TQEoKrNQ6H$leVcqqBDM69swVxULyjOaL6pdZmx7JNZLkxFJrXnkxnYwMRctZrdZtKqU8zH9rxkSaPfP3xsgZMRyQdnTCpwRwBDhlLvpYizZnEBDEgqSIBFfwl8xboGIBdltFSePKKhQpSfRngkIij7hiEeQstWcssZvntQwfAkenQLQGfBYwL0JdcPXN4kSR7bs$05KgQgH5faqimgo4Y7hjN6MacubhVBtWfRRoPQJlfgedmsh7Eikm#IwLxKaxcqBV4SNpLTYjyb6Kz2flP9uIs$6it0HDUN8iuDciFoCEvAcn5S#AcURigC#4hNbktCLmv2US7VM9S#y4RYq7SIjwXEaHJS8zY3jUVToJU48AuXvaTilTsQzWxbpsotAN9#KUnRzKt6b9k2jOOxahwt3dkjPsLntAVRwGyR8OpzftuDj8SsCVplq$Yq#3aVmTpNtz1EwZOtZdn$7iCfws0kxq1MnjxqwQOI$YckZ4qxe#ZnzeJkITpVj7LxuBTEVkTXXtfXuyeVVaVjoRwwqFrw7jSRQtrnSmnzezjbcruBj3d3sRCVsp8CmHYN6qfIKvX#rf9kDaiwU97BaUHpdvwkSe3#28vn5EoJ75p9vClcbaao#H8ylZKFH8pf75F#kNJIaPHrlEbEGS1JwEWbeSKnlCKM7UO1KvmhKuyZsEVFwbuiXFoX7lIoR7AjLzoQA7zidclKnsRtDJpZ7MyWIGoNoocKy21#sEGtYbu2Wq$fc#rJOzjghOZgkAltLMbU6Si9cH$l7UahtDFA27DmyerpiFK2ZcSgqAj9xOYcVmkgtuS6Lj0PyUTazMvkaHuOazOdPghQNvzknYy$GeOfiIFZtiiqGZZngV7hJhfqSUIurzq1uTq17xsZYqHCnO5BBKp3RNT6EBFJyAR4yqAtypY1mKyzUEJnvzzLCgekFGEitmU75CozOUHxxDqCZ5vE4JJMUki$FpU3tryUYORaIrl#rfN$JZsIN7MEq89$BeF1Du436#ojWZ7WzzJB#KYHmnF75xiPTpYOxbZPpriPdcsB4pDNdn#wozZPUDcnExdyRBzTBc7dW$8qQpVZbnBpiQV5B7szapXDzYnwCeLIitdlLOtAc0yu#ovKvt8px4tugM8RHb933LyedhRatfcHsJqWEbR9OxarMFKwwTWIwd3DQtywHqBq9wGaGTmRP9C$VRwuMn7UtBo8vXwWmZZZLTi$al6oCk6JQetQhCKJdCitJuWofpn6uOeD#u#JxZvAwQqybxRGxF$mkyvX13TJUi7ibpzaiu5Xyxspfdc#vAlb#6pjFV4QmUkkvlnbwMecuvUHzWZBnwE5RIxnNwzNJwQkg3hQp61lYtWNuNGuXl$6gkpyxTLhMa$I#MjyNjAbRkPT#jebbMZxPnzjqex#fiRHrNDzftT$BZb7iuN$t5fe$ptP7exEJkjemK4wLM3jzDUQ0llnMfnY6nZuhlbceHCJD9$MpoDsVvajFFeTwEvLgdpwD#ECUYcTClfCxSGfqQ5XzVfiXjMLmEVqkiT$PlY9SRsBytNFccApztvIQEsGBc6PlBjmQtZqwXp$QivnmFDNMslgbZXlJNEUOOljDnzuxNHMQw$bJw$1iHZPdJLIwtLRuwZdsqmiMjT3RkGw5COW#dxvaONtyl2BTfoFW4vu#Mt9fkSFBUVvVdVmbUJOXzE1RPLWztYTU5O#kaHq2xXRGFrJBxlFg$arkOfy38qlhz8WE8EtowopkoCY3l#Qvk8k6RBtZ8sMSGpwJ8QOqhh$NPtdVb1iVrcO$trs0UjItZPBYOevol$hRxbPOvfh$JfuFF$#Bwnc5pm9Yd4pK#VIxNIPfFNqozgKzVGhrLmxZLb0RwpIA6n#J$JB$GAYwhfvF4TNiQUlbixwRcZUrtuKMsZBJtjKrpvSgu3TsSpOmXx#VwHBv8FrUUKd#VzFDFN$Ad$2wRf4P#autogsoGN#HdMMzgrfdVjSHFyhryAz$8r$ALV2bVoEVocNmgdyZ7yf5yADNoWRmlxycxyewyBM$9c$A6l2wloQloYhmiBycBye8yBy$9i$ACF2tVIR4CSR5$97umqaF4WtAzN2UNonLohLn3$LAvK1RB8ZbA#iYHqbjwIKyvGdh8uNAO72hTfPjqbKEaY#DQ9fV8G1aW$QLG2fpDV6ELcuYbSgnSB1Sv#zLobHGv#KfP8fV9ZNA3qtbsaPL6Ma7SRwJbvlS#ytkl#RsBk9DOAFDbdfmli#KiQcVA6NAwLCbfSggS8YVBIUA#AijCcI7JPPfCTVeKLqvsPQKhJvH9Cb4cI8MKotWfat6qZPKnKYedoF4oIaRBI3dEU9QOtn4oM0R9WNA0x2$xIIVXQKY64yE8eOwJgr3cI6SvM0wIi#KyPpsNE4Ska6Ead$ILe#KEPx#Tk4TkamN2aupSAhSu#rF4axBQoAk8nvoTvoHvGlH$Y5x431wxkDTX0gUs$aepie4OZJ3VrJKYV6FNY68YEIQoRjGMXl7CRpppEmxwMx$2PEOvcUKavZ#9TITIZg6KjbBQIkbVYgqmXleOwcDPZcKvZkKqjfz6tn6KHz0sWd8PopAscKxRTEhz4N48cxA4jXAsimZplLOZuX3rbI526HJHfyYyQog30JuCPzrmbiDOFupbKFE5GZb47I86WratcFP11g468fh4vaTz7E40X7obSd8qmQUSzdBpxS6Ymc580ARKmi1$4yVwC3K92ly5IRt1FW==");
    private WorkingParseResult fWorking;

    public synchronized ParseResult parse(IParseState parseState) throws Exception {
        WorkingParseResult working = new WorkingParseResult();
        this.parse(parseState, working);
        return working.getImmutableResult();
    }

    protected synchronized void parse(IParseState parseState, WorkingParseResult working) throws Exception {
        this.fWorking = working;
        try {
            String source = parseState.getSource();
            CSSFlexScanner scanner = new CSSFlexScanner();
            scanner.setSource(source);
            ParseRootNode result = (ParseRootNode)this.parse(scanner, parseState.getNeedSleep());
            List<Symbol> comments = scanner.getComments();
            ArrayList<CSSCommentNode> commentNodes = new ArrayList<CSSCommentNode>(comments.size());
            for (Symbol comment : comments) {
                CSSCommentNode commentNode = new CSSCommentNode(source.substring(comment.getStart(), comment.getEnd() + 1), comment.getStart(), comment.getEnd());
                commentNodes.add(commentNode);
            }
            result.setCommentNodes(commentNodes.toArray(new IParseNode[commentNodes.size()]));
            int start = parseState.getStartingOffset();
            int length = source.length();
            result.setLocation(0, length - 1);
            if (start != 0) {
                ParseUtil.addOffset((IParseNode)result, (int)start, (boolean)parseState.getNeedSleep());
            }
            this.fWorking.setParseResult((IParseRootNode)result);
            EditorUtil.flexScannerYYclose((Object)((Object)scanner));
        }
        finally {
            this.fWorking = null;
        }
    }

    public CSSParser() {
        super(PARSING_TABLES);
        this.report = new CSSEvents();
    }

    protected Symbol invokeReduceAction(int rule_num, int offset) {
        switch (rule_num) {
            case 0: {
                Symbol _symbol_p = this._symbols[offset + 1];
                ArrayList _list_p = (ArrayList)_symbol_p.value;
                CSSNode[] p = _list_p == null ? new CSSNode[]{} : _list_p.toArray(new CSSNode[_list_p.size()]);
                return new CSSParseRootNode((Symbol[])p);
            }
            case 1: {
                return new CSSParseRootNode();
            }
            case 2: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 3: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 14: {
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                return new CSSCharSetNode(s);
            }
            case 15: {
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                return new CSSImportNode(s, new CSSTextNode[0]);
            }
            case 16: {
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                Symbol _symbol_m = this._symbols[offset + 3];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                Symbol[] m = _list_m == null ? new Symbol[]{} : _list_m.toArray(new Symbol[_list_m.size()]);
                ArrayList<CSSTextNode> list2 = new ArrayList<CSSTextNode>();
                Symbol[] symbolArray = m;
                int n = m.length;
                int n2 = 0;
                while (n2 < n) {
                    Symbol symbol = symbolArray[n2];
                    CSSTextNode text = new CSSTextNode((String)symbol.value);
                    text.setLocation(symbol.getStart(), symbol.getEnd());
                    list2.add(text);
                    ++n2;
                }
                return new CSSImportNode(s, list2.toArray(new CSSTextNode[list2.size()]));
            }
            case 17: {
                Symbol _symbol_m = this._symbols[offset + 2];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                Symbol[] m = _list_m == null ? new Symbol[]{} : _list_m.toArray(new Symbol[_list_m.size()]);
                ArrayList<CSSTextNode> list = new ArrayList<CSSTextNode>();
                Symbol[] symbolArray = m;
                int symbol = m.length;
                int list2 = 0;
                while (list2 < symbol) {
                    Symbol symbol2 = symbolArray[list2];
                    CSSTextNode text = new CSSTextNode((String)symbol2.value);
                    text.setLocation(symbol2.getStart(), symbol2.getEnd());
                    list.add(text);
                    ++list2;
                }
                return new CSSMediaNode(list.toArray(new CSSTextNode[list.size()]), new CSSNode[0]);
            }
            case 18: {
                Symbol _symbol_m = this._symbols[offset + 2];
                ArrayList _list_m = (ArrayList)_symbol_m.value;
                Symbol[] m = _list_m == null ? new Symbol[]{} : _list_m.toArray(new Symbol[_list_m.size()]);
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSNode[] s = _list_s == null ? new CSSNode[]{} : _list_s.toArray(new CSSNode[_list_s.size()]);
                ArrayList<CSSTextNode> list = new ArrayList<CSSTextNode>();
                Symbol[] symbolArray = m;
                int n = m.length;
                int text = 0;
                while (text < n) {
                    Symbol symbol = symbolArray[text];
                    CSSTextNode text2 = new CSSTextNode((String)symbol.value);
                    text2.setLocation(symbol.getStart(), symbol.getEnd());
                    list.add(text2);
                    ++text;
                }
                return new CSSMediaNode(list.toArray(new CSSTextNode[list.size()]), s);
            }
            case 19: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2]);
                return this._symbols[offset + 1];
            }
            case 20: {
                ArrayList<Symbol> lst = new ArrayList<Symbol>();
                lst.add(this._symbols[offset + 1]);
                return new Symbol(lst);
            }
            case 57: {
                Symbol k = this._symbols[offset + 1];
                Symbol _symbol_m = this._symbols[offset + 2];
                String m = (String)_symbol_m.value;
                CSSTextNode text = new CSSTextNode(m);
                text.setLocation(_symbol_m.getStart(), _symbol_m.getEnd());
                return new CSSKeyFramesNode((String)k.value, text, new CSSNode[0]);
            }
            case 58: {
                Symbol k = this._symbols[offset + 1];
                Symbol _symbol_m = this._symbols[offset + 2];
                String m = (String)_symbol_m.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSNode[] s = _list_s == null ? new CSSNode[]{} : _list_s.toArray(new CSSNode[_list_s.size()]);
                CSSTextNode text = new CSSTextNode(m);
                text.setLocation(_symbol_m.getStart(), _symbol_m.getEnd());
                return new CSSKeyFramesNode((String)k.value, text, s);
            }
            case 61: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 62: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 63: {
                Symbol s = this._symbols[offset + 1];
                CSSSimpleSelectorNode simple = new CSSSimpleSelectorNode((String)s.value);
                simple.setLocation(s.getStart(), s.getEnd());
                CSSSelectorNode selector = new CSSSelectorNode(simple);
                selector.setLocation(simple.getStart(), simple.getEnd());
                ArrayList<CSSSelectorNode> list = new ArrayList<CSSSelectorNode>();
                list.add(selector);
                CSSRuleNode result = new CSSRuleNode(list);
                selector.setParent((IParseNode)result);
                return result;
            }
            case 64: {
                Symbol s = this._symbols[offset + 1];
                Symbol _symbol_d = this._symbols[offset + 3];
                List d = (List)_symbol_d.value;
                CSSSimpleSelectorNode simple = new CSSSimpleSelectorNode((String)s.value);
                simple.setLocation(s.getStart(), s.getEnd());
                CSSSelectorNode selector = new CSSSelectorNode(simple);
                selector.setLocation(simple.getStart(), simple.getEnd());
                ArrayList<CSSSelectorNode> list = new ArrayList<CSSSelectorNode>();
                list.add(selector);
                CSSRuleNode result = new CSSRuleNode(list, d);
                selector.setParent((IParseNode)result);
                for (CSSDeclarationNode declaration : d) {
                    declaration.setParent((IParseNode)selector);
                }
                return result;
            }
            case 68: {
                return new CSSPageNode();
            }
            case 69: {
                Symbol _symbol_d = this._symbols[offset + 3];
                List d = (List)_symbol_d.value;
                return new CSSPageNode(d);
            }
            case 70: {
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                CSSPageSelectorNode pageSelector = new CSSPageSelectorNode(s);
                CSSPageNode result = new CSSPageNode();
                pageSelector.setLocation(_symbol_s.getStart(), _symbol_s.getEnd());
                result.setSelector(pageSelector);
                return result;
            }
            case 71: {
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                Symbol _symbol_d = this._symbols[offset + 5];
                List d = (List)_symbol_d.value;
                CSSPageSelectorNode pageSelector = new CSSPageSelectorNode(s);
                CSSPageNode result = new CSSPageNode(d);
                pageSelector.setLocation(_symbol_s.getStart(), _symbol_s.getEnd());
                result.setSelector(pageSelector);
                return result;
            }
            case 72: {
                return new CSSFontFaceNode();
            }
            case 73: {
                Symbol _symbol_d = this._symbols[offset + 3];
                List d = (List)_symbol_d.value;
                return new CSSFontFaceNode(d);
            }
            case 74: {
                Symbol _symbol_w = this._symbols[offset + 2];
                String w = (String)_symbol_w.value;
                return new CSSNamespaceNode(w);
            }
            case 75: {
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_w = this._symbols[offset + 3];
                String w = (String)_symbol_w.value;
                return new CSSNamespaceNode(i, w);
            }
            case 76: {
                Symbol _symbol_a = this._symbols[offset + 1];
                String a = (String)_symbol_a.value;
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                return new CSSAtRuleNode(a, s);
            }
            case 77: {
                Symbol _symbol_rs = this._symbols[offset + 1];
                CSSList rs = (CSSList)((Object)_symbol_rs.value);
                Symbol _symbol_r = this._symbols[offset + 2];
                CSSRuleNode r = (CSSRuleNode)((Object)_symbol_r.value);
                rs.addChild((IParseNode)r);
                return rs;
            }
            case 78: {
                Symbol _symbol_r = this._symbols[offset + 1];
                CSSRuleNode r = (CSSRuleNode)((Object)_symbol_r.value);
                CSSList list = new CSSList();
                list.addChild((IParseNode)r);
                return list;
            }
            case 79: {
                Symbol _symbol_s = this._symbols[offset + 1];
                List s = (List)_symbol_s.value;
                CSSRuleNode result = new CSSRuleNode(s);
                for (CSSSelectorNode selector : s) {
                    selector.setParent((IParseNode)result);
                }
                return result;
            }
            case 80: {
                Symbol _symbol_s = this._symbols[offset + 1];
                List s = (List)_symbol_s.value;
                Symbol _symbol_d = this._symbols[offset + 3];
                List d = (List)_symbol_d.value;
                CSSRuleNode result = new CSSRuleNode(s, d);
                for (CSSSelectorNode selector : s) {
                    selector.setParent((IParseNode)result);
                }
                CSSSelectorNode firstSelector = (CSSSelectorNode)((Object)s.get(0));
                for (CSSDeclarationNode declaration : d) {
                    declaration.setParent((IParseNode)firstSelector);
                }
                return result;
            }
            case 82: {
                Symbol _symbol_fs = this._symbols[offset + 2];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                CSSMozDocument doc = new CSSMozDocument();
                doc.addChild((IParseNode)fs);
                doc.addChild((IParseNode)new CSSList());
                return doc;
            }
            case 83: {
                Symbol _symbol_fs = this._symbols[offset + 2];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                Symbol _symbol_rs = this._symbols[offset + 4];
                CSSList rs = (CSSList)((Object)_symbol_rs.value);
                CSSMozDocument doc = new CSSMozDocument();
                doc.addChild((IParseNode)fs);
                doc.addChild((IParseNode)rs);
                return doc;
            }
            case 84: {
                Symbol _symbol_fs = this._symbols[offset + 1];
                CSSList fs = (CSSList)((Object)_symbol_fs.value);
                Symbol _symbol_f = this._symbols[offset + 3];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                fs.addChild((IParseNode)f);
                return fs;
            }
            case 85: {
                Symbol _symbol_f = this._symbols[offset + 1];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                CSSList list = new CSSList();
                list.addChild((IParseNode)f);
                return list;
            }
            case 86: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol cfr_ignored_0 = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol cfr_ignored_1 = this._symbols[offset + 4];
                return new CSSFunctionNode(i, e);
            }
            case 87: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol cfr_ignored_2 = this._symbols[offset + 2];
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol cfr_ignored_3 = this._symbols[offset + 4];
                return new CSSFunctionNode(i, e);
            }
            case 88: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new CSSFunctionNode(i, null);
            }
            case 89: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                return new CSSFunctionNode(i, e);
            }
            case 90: {
                Symbol _symbol_d = this._symbols[offset + 1];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                ArrayList<CSSDeclarationNode> list = new ArrayList<CSSDeclarationNode>();
                list.add(d);
                return new Symbol(list);
            }
            case 91: {
                Symbol _symbol_d = this._symbols[offset + 1];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                Symbol s = this._symbols[offset + 2];
                ArrayList<CSSDeclarationNode> list = new ArrayList<CSSDeclarationNode>();
                d.setHasSemicolon(s);
                list.add(d);
                return new Symbol(list);
            }
            case 92: {
                Symbol _symbol_ds = this._symbols[offset + 1];
                List ds = (List)_symbol_ds.value;
                Symbol _symbol_d = this._symbols[offset + 2];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                ds.add(d);
                return this._symbols[offset + 1];
            }
            case 93: {
                Symbol _symbol_ds = this._symbols[offset + 1];
                List ds = (List)_symbol_ds.value;
                Symbol _symbol_d = this._symbols[offset + 2];
                CSSDeclarationNode d = (CSSDeclarationNode)((Object)_symbol_d.value);
                Symbol s = this._symbols[offset + 3];
                d.setHasSemicolon(s);
                ds.add(d);
                return this._symbols[offset + 1];
            }
            case 94: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                return new CSSDeclarationNode(i, e);
            }
            case 95: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 3];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol s = this._symbols[offset + 4];
                return new CSSDeclarationNode(i, e, s);
            }
            case 96: {
                Symbol _symbol_a = this._symbols[offset + 1];
                String a = (String)_symbol_a.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                return new CSSDeclarationNode(String.valueOf(a) + i, e);
            }
            case 97: {
                Symbol _symbol_a = this._symbols[offset + 1];
                String a = (String)_symbol_a.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol s = this._symbols[offset + 5];
                return new CSSDeclarationNode(String.valueOf(a) + i, e, s);
            }
            case 98: {
                Symbol _symbol_a = this._symbols[offset + 1];
                String a = (String)_symbol_a.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                return new CSSDeclarationNode(String.valueOf(a) + i, e);
            }
            case 99: {
                Symbol _symbol_a = this._symbols[offset + 1];
                String a = (String)_symbol_a.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_e = this._symbols[offset + 4];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol s = this._symbols[offset + 5];
                return new CSSDeclarationNode(String.valueOf(a) + i, e, s);
            }
            case 100: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new CSSDeclarationNode(i, null);
            }
            case 101: {
                Symbol _symbol_i = this._symbols[offset + 1];
                String i = (String)_symbol_i.value;
                return new CSSDeclarationNode(i, null);
            }
            case 102: {
                return new CSSErrorDeclarationNode();
            }
            case 103: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol _symbol_s = this._symbols[offset + 2];
                String s = (String)_symbol_s.value;
                Symbol _symbol_t = this._symbols[offset + 3];
                CSSExpressionNode t = (CSSExpressionNode)((Object)_symbol_t.value);
                return new CSSTermListNode(e, t, s);
            }
            case 104: {
                Symbol _symbol_e = this._symbols[offset + 1];
                CSSExpressionNode e = (CSSExpressionNode)((Object)_symbol_e.value);
                Symbol _symbol_t = this._symbols[offset + 2];
                CSSExpressionNode t = (CSSExpressionNode)((Object)_symbol_t.value);
                return new CSSTermListNode(e, t);
            }
            case 106: {
                return new CSSErrorExpressionNode();
            }
            case 107: {
                Symbol _symbol_e = this._symbols[offset + 1];
                String e = (String)_symbol_e.value;
                CSSIEExpressionNode expressionNode = new CSSIEExpressionNode(e, _symbol_e.getStart(), _symbol_e.getEnd());
                return expressionNode;
            }
            case 108: {
                Symbol _symbol_p = this._symbols[offset + 1];
                String p = (String)_symbol_p.value;
                return new CSSTermNode(p);
            }
            case 110: {
                Symbol _symbol_ss = this._symbols[offset + 1];
                List ss = (List)_symbol_ss.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                CSSSelectorNode lastSelector = (CSSSelectorNode)((Object)ss.get(ss.size() - 1));
                lastSelector.setCombinator(c);
                ss.add(s);
                return this._symbols[offset + 1];
            }
            case 111: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                ArrayList<CSSSelectorNode> list = new ArrayList<CSSSelectorNode>();
                list.add(s);
                return new Symbol(list);
            }
            case 112: {
                Symbol _symbol_s = this._symbols[offset + 1];
                CSSSelectorNode s = (CSSSelectorNode)((Object)_symbol_s.value);
                Symbol _symbol_ss = this._symbols[offset + 2];
                CSSSimpleSelectorNode ss = (CSSSimpleSelectorNode)((Object)_symbol_ss.value);
                s.addChild((IParseNode)ss);
                return s;
            }
            case 113: {
                Symbol _symbol_ss = this._symbols[offset + 1];
                CSSSimpleSelectorNode ss = (CSSSimpleSelectorNode)((Object)_symbol_ss.value);
                CSSSelectorNode selector = new CSSSelectorNode(new CSSSimpleSelectorNode[0]);
                selector.addChild((IParseNode)ss);
                return selector;
            }
            case 114: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_a = this._symbols[offset + 2];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                CSSAttributeSelectorNode[] a = _list_a == null ? new CSSAttributeSelectorNode[]{} : _list_a.toArray(new CSSAttributeSelectorNode[_list_a.size()]);
                return new CSSSimpleSelectorNode(t, a);
            }
            case 115: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                return new CSSSimpleSelectorNode(t);
            }
            case 116: {
                Symbol _symbol_a = this._symbols[offset + 1];
                ArrayList _list_a = (ArrayList)_symbol_a.value;
                CSSAttributeSelectorNode[] a = _list_a == null ? new CSSAttributeSelectorNode[]{} : _list_a.toArray(new CSSAttributeSelectorNode[_list_a.size()]);
                return new CSSSimpleSelectorNode(a);
            }
            case 117: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_c1 = this._symbols[offset + 2];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                String s = (String)_symbol_s.value;
                return new CSSSimpleSelectorNode(String.valueOf(t) + c1 + "(" + s + ")");
            }
            case 118: {
                Symbol _symbol_t = this._symbols[offset + 1];
                String t = (String)_symbol_t.value;
                Symbol _symbol_c1 = this._symbols[offset + 2];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSAttributeSelectorNode[] s = _list_s == null ? new CSSAttributeSelectorNode[]{} : _list_s.toArray(new CSSAttributeSelectorNode[_list_s.size()]);
                String type = s.toString();
                if (s.getClass().isArray()) {
                    type = s[0].toString();
                }
                return new CSSSimpleSelectorNode(String.valueOf(t) + c1 + "(" + type + ")");
            }
            case 119: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                String s = (String)_symbol_s.value;
                return new CSSSimpleSelectorNode(String.valueOf(c1) + "(" + s + ")");
            }
            case 120: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_s = this._symbols[offset + 3];
                ArrayList _list_s = (ArrayList)_symbol_s.value;
                CSSAttributeSelectorNode[] s = _list_s == null ? new CSSAttributeSelectorNode[]{} : _list_s.toArray(new CSSAttributeSelectorNode[_list_s.size()]);
                String type = s.toString();
                if (s.getClass().isArray()) {
                    type = s[0].toString();
                }
                return new CSSSimpleSelectorNode(String.valueOf(c1) + "(" + type + ")");
            }
            case 121: {
                ((ArrayList)this._symbols[offset + 1].value).add(this._symbols[offset + 2].value);
                return this._symbols[offset + 1];
            }
            case 122: {
                ArrayList<Object> lst = new ArrayList<Object>();
                lst.add(this._symbols[offset + 1].value);
                return new Symbol(lst);
            }
            case 123: {
                Symbol _symbol_c = this._symbols[offset + 1];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(c);
            }
            case 124: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 125: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 126: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 127: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 128: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 129: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 130: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 131: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 132: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 133: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 134: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c + "(" + i + ")");
            }
            case 135: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 136: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 137: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 138: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 139: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_4 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 140: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_5 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 141: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_6 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 142: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                Symbol _symbol_i = this._symbols[offset + 4];
                CSSExpressionNode cfr_ignored_7 = (CSSExpressionNode)((Object)_symbol_i.value);
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 143: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 144: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 145: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 146: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 147: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 148: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 149: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 150: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c = this._symbols[offset + 2];
                String c = (String)_symbol_c.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c);
            }
            case 151: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 152: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 153: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 154: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 155: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 156: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + i);
            }
            case 157: {
                Symbol _symbol_c1 = this._symbols[offset + 1];
                String c1 = (String)_symbol_c1.value;
                Symbol _symbol_c2 = this._symbols[offset + 2];
                String c2 = (String)_symbol_c2.value;
                Symbol _symbol_i = this._symbols[offset + 3];
                String i = (String)_symbol_i.value;
                return new CSSAttributeSelectorNode(String.valueOf(c1) + c2 + i);
            }
            case 158: {
                Symbol _symbol_f = this._symbols[offset + 2];
                CSSExpressionNode f = (CSSExpressionNode)((Object)_symbol_f.value);
                return new CSSAttributeSelectorNode(f);
            }
            case 159: {
                Symbol _symbol_h = this._symbols[offset + 1];
                String h = (String)_symbol_h.value;
                return new CSSAttributeSelectorNode(h);
            }
            case 160: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 161: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_o = this._symbols[offset + 3];
                String o = (String)_symbol_o.value;
                Symbol _symbol_s = this._symbols[offset + 4];
                String s = (String)_symbol_s.value;
                Symbol _symbol_r = this._symbols[offset + 5];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + " " + o + " " + s + r);
            }
            case 162: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 163: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 164: {
                Symbol _symbol_l = this._symbols[offset + 1];
                String l = (String)_symbol_l.value;
                Symbol _symbol_i = this._symbols[offset + 2];
                String i = (String)_symbol_i.value;
                Symbol _symbol_r = this._symbols[offset + 3];
                String r = (String)_symbol_r.value;
                return new CSSAttributeSelectorNode(String.valueOf(l) + i + r);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 81: 
            case 105: 
            case 109: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: {
                return this._symbols[offset + 1];
            }
        }
        throw new IllegalArgumentException("unknown production #" + rule_num);
    }

    private class CSSEvents
    extends Parser.Events {
        private CSSEvents() {
        }

        public void scannerError(Scanner.Exception e) {
        }

        public void syntaxError(Symbol token) {
            if (token == null || CSSParser.this.fWorking == null) {
                return;
            }
            CSSParser.this.fWorking.addError((IParseError)new ParseError("com.aptana.contenttype.css", token, IParseError.Severity.ERROR));
        }

        public void unexpectedTokenRemoved(Symbol token) {
        }

        public void missingTokenInserted(Symbol token) {
        }

        public void misspelledTokenReplaced(Symbol token) {
        }

        public void errorPhraseRemoved(Symbol error) {
        }
    }
}

