/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.internal.text;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.URIUtil;
import com.aptana.editor.common.hover.TagStripperAndTypeBolder;
import com.aptana.editor.css.contentassist.model.ElementElement;
import com.aptana.editor.css.contentassist.model.ICSSMetadataElement;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.PseudoClassElement;
import com.aptana.editor.css.contentassist.model.PseudoElementElement;
import com.aptana.editor.css.contentassist.model.SpecificationElement;
import com.aptana.editor.css.contentassist.model.UserAgentElement;
import com.aptana.editor.css.internal.text.Messages;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CSSModelFormatter {
    private static final String HTML_NEWLINE = "<br>";
    public static final CSSModelFormatter TEXT_HOVER = new CSSModelFormatter(true, Section.SPECIFICATIONS, Section.SIGNATURE, Section.DESCRIPTION, Section.REMARK, Section.EXAMPLE);
    public static final CSSModelFormatter LABEL = new CSSModelFormatter(false, Section.SIGNATURE);
    public static final CSSModelFormatter ADDITIONAL_INFO = new CSSModelFormatter(true, Section.SIGNATURE, Section.DESCRIPTION, Section.REMARK, Section.EXAMPLE);
    private List<Section> fSections;
    private boolean useHTML;

    private CSSModelFormatter(boolean useHTML, Section ... sectionsToDisplay) {
        this.fSections = Arrays.asList(sectionsToDisplay);
        this.useHTML = useHTML;
        for (Section s : this.fSections) {
            s.useHTML = useHTML;
        }
    }

    public static String getDocumentDisplayName(String document) {
        String result = null;
        if (document != null) {
            int index = document.lastIndexOf(47);
            result = index != -1 ? document.substring(index + 1) : document;
            result = URIUtil.decodeURI((String)result);
        }
        return result;
    }

    public String getHeader(ICSSMetadataElement element) {
        return this.getHeader(CollectionsUtil.newList((Object[])new ICSSMetadataElement[]{element}));
    }

    public String getHeader(final Collection<ICSSMetadataElement> elements) {
        String headers;
        int index;
        if (CollectionsUtil.isEmpty(elements)) {
            return "";
        }
        ArrayList<String> stringParts = new ArrayList<String>(this.fSections.size() + 2);
        if (this.useHTML) {
            stringParts.add("<b>");
        }
        List headerSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section item) {
                return item.isHeader();
            }
        });
        stringParts.addAll(CollectionsUtil.map((Collection)headerSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(elements, null);
            }
        }));
        if (this.useHTML) {
            stringParts.add("</b>");
        }
        if ((index = (headers = StringUtil.concat(stringParts)).indexOf("-")) == 3) {
            headers = headers.replaceFirst("-", "");
        }
        return headers;
    }

    public String getDocumentation(ICSSMetadataElement element) {
        return this.getDocumentation(CollectionsUtil.newList((Object[])new ICSSMetadataElement[]{element}));
    }

    public String getDocumentation(final Collection<ICSSMetadataElement> elements) {
        List docSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section s) {
                return !s.isHeader();
            }
        });
        List sectionStrings = CollectionsUtil.map((Collection)docSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(elements, null);
            }
        });
        return StringUtil.concat((Collection)sectionStrings);
    }

    protected String newline() {
        return this.useHTML ? HTML_NEWLINE : FileUtil.NEW_LINE;
    }

    private static abstract class Section {
        protected boolean useHTML;
        private String name;
        static final Section SIGNATURE = new Section("SIGNATURE"){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                ICSSMetadataElement element = elements.iterator().next();
                String reference = "";
                if (element instanceof PropertyElement) {
                    PropertyElement propertyElement = (PropertyElement)element;
                    reference = propertyElement.getType();
                }
                if (StringUtil.isNotBlank((String)reference)) {
                    reference = "-" + reference;
                }
                return reference;
            }
        };
        static final Section EXAMPLE = new Section("EXAMPLE"){

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                String example = this.getFirstExample(elements);
                return this.addSection(Messages.CSSModelFormatter_ExampleSection, example);
            }

            private String getFirstExample(Collection<ICSSMetadataElement> elements) {
                for (ICSSMetadataElement element : elements) {
                    String example = element.getExample();
                    if (StringUtil.isEmpty((String)example)) continue;
                    return example;
                }
                return "";
            }
        };
        static final Section EXAMPLES = new Section("EXAMPLES"){

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                List examples = new ArrayList<String>(elements.size());
                for (ICSSMetadataElement element : elements) {
                    examples.add(element.getExample());
                }
                if ((examples = CollectionsUtil.filter(examples, (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return !StringUtil.isEmpty((String)item);
                    }
                })).size() == 1) {
                    return this.addSection(Messages.CSSModelFormatter_ExampleSection, (String)examples.get(0));
                }
                ArrayList<String> builder = new ArrayList<String>();
                int i = 0;
                while (i < examples.size()) {
                    builder.add(this.addSection(MessageFormat.format(Messages.CSSModelFormatter_Example_Number, i + 1), (String)examples.get(i)));
                    ++i;
                }
                return StringUtil.concat(builder);
            }
        };
        static final Section REMARK = new Section("REMARK"){

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                String remark = this.getFirstRemark(elements);
                if (remark == null) {
                    return "";
                }
                return this.addSection(Messages.CSSModelFormatter_RemarksSection, remark);
            }

            private String getFirstRemark(Collection<ICSSMetadataElement> elements) {
                for (ICSSMetadataElement element : elements) {
                    String remark = null;
                    if (element instanceof ElementElement) {
                        remark = ((ElementElement)element).getRemark();
                    } else if (element instanceof PropertyElement) {
                        remark = ((PropertyElement)element).getRemark();
                    }
                    if (StringUtil.isEmpty((String)remark)) continue;
                    return remark;
                }
                return "";
            }
        };
        static final Section SPECIFICATIONS = new Section("SPECIFICATIONS"){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                HashSet<SpecificationElement> specs = new HashSet<SpecificationElement>();
                for (ICSSMetadataElement element : elements) {
                    if (element instanceof PropertyElement) {
                        specs.addAll(((PropertyElement)element).getSpecifications());
                        continue;
                    }
                    if (element instanceof PseudoClassElement) {
                        specs.addAll(((PseudoClassElement)element).getSpecifications());
                        continue;
                    }
                    if (!(element instanceof PseudoElementElement)) continue;
                    specs.addAll(((PseudoElementElement)element).getSpecifications());
                }
                if (CollectionsUtil.isEmpty(specs)) {
                    return "";
                }
                return this.getSpecificationsString(specs);
            }

            private String getSpecificationsString(Collection<SpecificationElement> specs) {
                List strings = CollectionsUtil.map(specs, (IMap)new IMap<SpecificationElement, String>(){

                    public String map(SpecificationElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(" ").append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)"|", (Collection)strings);
            }
        };
        static final Section DESCRIPTION = new Section("DESCRIPTION"){
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                HashSet<String> descriptions = new HashSet<String>();
                for (ICSSMetadataElement element : elements) {
                    this.stripAndBold.setUseHTML(this.useHTML);
                    String desc = this.stripAndBold.searchAndReplace(element.getDescription());
                    if (StringUtil.isEmpty((String)desc)) continue;
                    descriptions.add(desc);
                }
                if (CollectionsUtil.isEmpty(descriptions)) {
                    return Messages.CSSModelFormatter_NoDescription;
                }
                return StringUtil.join((String)", ", descriptions);
            }
        };
        static final Section PLATFORMS = new Section("PLATFORMS"){

            @Override
            public String generate(Collection<ICSSMetadataElement> elements, URI root) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>();
                for (ICSSMetadataElement element : elements) {
                    userAgents.addAll(element.getUserAgents());
                }
                return this.addSection(Messages.CSSModelFormatter_SupportedPlatforms, this.getPlatforms(userAgents));
            }

            private String getPlatforms(Collection<UserAgentElement> userAgents) {
                List strings = CollectionsUtil.map(userAgents, (IMap)new IMap<UserAgentElement, String>(){

                    public String map(UserAgentElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getPlatform());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(": ").append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)", ", (Collection)strings);
            }
        };

        private Section(String name) {
            this.name = name;
        }

        public boolean isHeader() {
            return false;
        }

        private String newline() {
            return this.useHTML ? CSSModelFormatter.HTML_NEWLINE : FileUtil.NEW_LINE;
        }

        protected String addSection(String title, String value) {
            StringBuilder builder = new StringBuilder();
            if (!StringUtil.isEmpty((String)value)) {
                builder.append(this.newline()).append(this.newline());
                if (this.useHTML) {
                    builder.append("<b>");
                }
                builder.append(title);
                if (this.useHTML) {
                    builder.append("</b>");
                }
                if (Messages.CSSModelFormatter_ExampleSection.equals(title)) {
                    value = value.replaceAll("(\n|\r)\\s*", "<br/>");
                }
                builder.append(this.newline());
                builder.append(value.trim());
            }
            return builder.toString();
        }

        public String toString() {
            return this.name;
        }

        public abstract String generate(Collection<ICSSMetadataElement> var1, URI var2);
    }
}

