/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.internal.text;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.text.AbstractFoldingComputer;
import com.aptana.editor.css.parsing.ast.CSSCommentNode;
import com.aptana.editor.css.parsing.ast.CSSFontFaceNode;
import com.aptana.editor.css.parsing.ast.CSSKeyFramesNode;
import com.aptana.editor.css.parsing.ast.CSSMediaNode;
import com.aptana.editor.css.parsing.ast.CSSPageNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseRootNode;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;

public class CSSFoldingComputer
extends AbstractFoldingComputer {
    public CSSFoldingComputer(AbstractThemeableEditor editor, IDocument document) {
        super(editor, document);
    }

    public boolean isFoldable(IParseNode child) {
        return child instanceof CSSCommentNode || child instanceof CSSRuleNode || child instanceof CSSMediaNode || child instanceof CSSPageNode || child instanceof CSSFontFaceNode || child instanceof CSSKeyFramesNode;
    }

    protected IParseNode[] getChildren(IParseNode parseNode) {
        if (parseNode instanceof CSSMediaNode) {
            CSSMediaNode mediaNode = (CSSMediaNode)parseNode;
            return mediaNode.getStatements();
        }
        if (parseNode instanceof CSSKeyFramesNode) {
            CSSKeyFramesNode mediaNode = (CSSKeyFramesNode)parseNode;
            return mediaNode.getStatements();
        }
        return super.getChildren(parseNode);
    }

    protected boolean traverseInto(IParseNode child) {
        return child instanceof CSSMediaNode || child instanceof CSSKeyFramesNode || (child instanceof ParseRootNode || child instanceof CSSPageNode) && child.hasChildren();
    }

    public boolean isCollapsed(IParseNode node) {
        if (node instanceof CSSCommentNode) {
            return Platform.getPreferencesService().getBoolean("com.aptana.editor.css", "fold_comments", false, null);
        }
        if (node instanceof CSSRuleNode) {
            return Platform.getPreferencesService().getBoolean("com.aptana.editor.css", "fold_rules", false, null);
        }
        return false;
    }
}

