/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.editor.css.contentassist.model.SpecificationElement;
import com.aptana.editor.css.contentassist.model.SubElement;
import com.aptana.editor.css.contentassist.model.ValueElement;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyElement
extends BaseElement<Property> {
    private static final String SPECIFICATIONS_PROPERTY = "specifications";
    private static final String VALUES_PROPERTY = "values";
    private static final String SUBS_PROPERTY = "subs";
    private static final String ALLOW_MULTIPLE_VALUES_PROPERTY = "allowMultipleValues";
    private static final String HINT_PROPERTY = "hint";
    private static final String REMARK_PROPERTY = "remark";
    private static final String TYPE_PROPERTY = "type";
    private boolean _allowMultipleValues;
    private String _type;
    private List<SpecificationElement> _specifications;
    private String _hint;
    private String _remark;
    private List<ValueElement> _values;
    private List<SubElement> _subs;

    public void addSpecification(SpecificationElement specification) {
        if (specification != null) {
            if (this._specifications == null) {
                this._specifications = new ArrayList<SpecificationElement>();
            }
            this._specifications.add(specification);
        }
    }

    public void addValue(ValueElement value) {
        if (value != null) {
            if (this._values == null) {
                this._values = new ArrayList<ValueElement>();
            }
            this._values.add(value);
        }
    }

    public void addSub(SubElement sub) {
        if (sub != null) {
            if (this._subs == null) {
                this._subs = new ArrayList<SubElement>();
            }
            this._subs.add(sub);
        }
    }

    public boolean allowMultipleValues() {
        return this._allowMultipleValues;
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setType(StringUtil.getStringValue(object.get(TYPE_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this.setHint(StringUtil.getStringValue(object.get(HINT_PROPERTY)));
        this.setAllowMultipleValues(Boolean.TRUE == object.get(ALLOW_MULTIPLE_VALUES_PROPERTY));
        this._values = IndexUtil.createList(object.get(VALUES_PROPERTY), ValueElement.class);
        this._subs = IndexUtil.createList(object.get(SUBS_PROPERTY), SubElement.class);
        this._specifications = IndexUtil.createList(object.get(SPECIFICATIONS_PROPERTY), SpecificationElement.class);
    }

    public String getHint() {
        return StringUtil.getStringValue((Object)this._hint);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public List<SpecificationElement> getSpecifications() {
        return CollectionsUtil.getListValue(this._specifications);
    }

    public String getType() {
        return StringUtil.getStringValue((Object)this._type);
    }

    public List<String> getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtil.isNotBlank((String)this._type)) {
            if (this._type.indexOf("|") > 0) {
                String[] types;
                String[] stringArray = types = this._type.split("\\|");
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    if (StringUtil.isNotBlank((String)t)) {
                        list.add(t);
                    }
                    ++n2;
                }
            } else {
                list.add(this._type);
            }
        }
        return list;
    }

    public List<ValueElement> getValues() {
        return CollectionsUtil.getListValue(this._values);
    }

    public List<SubElement> getSubs() {
        return CollectionsUtil.getListValue(this._subs);
    }

    public void setAllowMultipleValues(Boolean value) {
        this._allowMultipleValues = value;
    }

    public void setHint(String hint) {
        this._hint = hint;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(TYPE_PROPERTY, (Object)this.getType());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(HINT_PROPERTY, (Object)this.getHint());
        out.add(ALLOW_MULTIPLE_VALUES_PROPERTY, this.allowMultipleValues());
        out.add(VALUES_PROPERTY, this.getValues());
        out.add(SUBS_PROPERTY, this.getSubs());
        out.add(SPECIFICATIONS_PROPERTY, this.getSpecifications());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyElement)) {
            return false;
        }
        PropertyElement other = (PropertyElement)obj;
        return ObjectUtil.areEqual((Object)this.getName(), (Object)other.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    static enum Property implements IPropertyInformation<PropertyElement>
    {
        NAME(Messages.PropertyElement_NameLabel){

            public Object getPropertyValue(PropertyElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

