/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IdGroupElement
extends BaseElement<Property> {
    private Index index;
    private List<String> ids;

    public IdGroupElement(Index index) {
        this.index = index;
        this.setName(Messages.IdGroupElement_IdGroupName);
    }

    public List<String> getIds() {
        if (this.ids == null) {
            CSSIndexQueryHelper queryHelper = new CSSIndexQueryHelper();
            Map<String, String> members = queryHelper.getIDs(this.index);
            this.ids = !CollectionsUtil.isEmpty(members) ? new ArrayList<String>(members.keySet()) : Collections.emptyList();
        }
        return this.ids;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<IdGroupElement>
    {
        NAME(Messages.IdGroupElement_NameLabel){

            public Object getPropertyValue(IdGroupElement node) {
                return node.getName();
            }
        }
        ,
        COUNT(Messages.IdGroupElement_CountLabel){

            public Object getPropertyValue(IdGroupElement node) {
                return node.getIds().size();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

