/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.index.core.IndexUtil;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElementElement
extends BaseElement<Property> {
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String REMARK_PROPERTY = "remark";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private String _displayName;
    private List<String> _properties;
    private String _remark;

    public void addProperty(String name) {
        if (name != null && name.length() > 0) {
            if (this._properties == null) {
                this._properties = new ArrayList<String>();
            }
            this._properties.add(name);
        }
    }

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setDisplayName(StringUtil.getStringValue(object.get(DISPLAY_NAME_PROPERTY)));
        this.setRemark(StringUtil.getStringValue(object.get(REMARK_PROPERTY)));
        this._properties = IndexUtil.createList(object.get(PROPERTIES_PROPERTY));
    }

    public String getDisplayName() {
        return StringUtil.getStringValue((Object)this._displayName);
    }

    public List<String> getProperties() {
        return CollectionsUtil.getListValue(this._properties);
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    public String getRemark() {
        return StringUtil.getStringValue((Object)this._remark);
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setRemark(String remark) {
        this._remark = remark;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(DISPLAY_NAME_PROPERTY, (Object)this.getDisplayName());
        out.add(REMARK_PROPERTY, (Object)this.getRemark());
        out.add(PROPERTIES_PROPERTY, this.getProperties());
    }

    static enum Property implements IPropertyInformation<ElementElement>
    {
        NAME(Messages.ElementElement_NameLabel){

            public Object getPropertyValue(ElementElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

