/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.contentassist.CSSIndexQueryHelper;
import com.aptana.editor.css.contentassist.model.BaseElement;
import com.aptana.editor.css.contentassist.model.Messages;
import com.aptana.index.core.Index;
import com.aptana.index.core.ui.views.IPropertyInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassGroupElement
extends BaseElement<Property> {
    private Index index;
    private List<String> classes;

    public ClassGroupElement(Index index) {
        this.index = index;
        this.setName(Messages.ClassGroupElement_ClassGroupElementName);
    }

    public List<String> getClasses() {
        if (this.classes == null) {
            CSSIndexQueryHelper queryHelper = new CSSIndexQueryHelper();
            Map<String, String> members = queryHelper.getClasses(this.index);
            this.classes = !CollectionsUtil.isEmpty(members) ? new ArrayList<String>(members.keySet()) : Collections.emptyList();
        }
        return this.classes;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    static enum Property implements IPropertyInformation<ClassGroupElement>
    {
        NAME(Messages.ClassGroupElement_NameLabel){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getName();
            }
        }
        ,
        COUNT(Messages.ClassGroupElement_CountLabel){

            public Object getPropertyValue(ClassGroupElement node) {
                return node.getClasses().size();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

