/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.index.CSSIndexCacher;
import com.aptana.editor.css.contentassist.model.ElementElement;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.PseudoClassElement;
import com.aptana.editor.css.contentassist.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexReader;
import com.aptana.index.core.QueryResult;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class CSSIndexReader
extends IndexReader {
    private ElementElement createElement(QueryResult element) {
        return (ElementElement)this.populateElement(new ElementElement(), element, 1);
    }

    private PropertyElement createProperty(QueryResult property) {
        return (PropertyElement)this.populateElement(new PropertyElement(), property, 1);
    }

    private PseudoClassElement createPseudoClass(QueryResult pseudoClass) {
        return (PseudoClassElement)this.populateElement(new PseudoClassElement(), pseudoClass);
    }

    private PseudoElementElement createPseudoElement(QueryResult pseudoElement) {
        return (PseudoElementElement)this.populateElement(new PseudoElementElement(), pseudoElement);
    }

    protected String getDelimiter() {
        return "\u0000";
    }

    public List<ElementElement> getElements(Index index) throws IOException {
        List items;
        ArrayList<ElementElement> result = new ArrayList<ElementElement>();
        if (index != null && (items = index.query(new String[]{"css.element"}, "*", 2)) != null) {
            for (QueryResult element : items) {
                result.add(this.createElement(element));
            }
        }
        return result;
    }

    public List<ElementElement> getElements(Index index, String ... names) throws IOException {
        ArrayList<ElementElement> result = new ArrayList<ElementElement>();
        if (index != null && names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                List elements = index.query(new String[]{"css.element"}, String.valueOf(name) + "\u0000", 1);
                if (elements != null) {
                    for (QueryResult element : elements) {
                        result.add(this.createElement(element));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public List<PropertyElement> getProperties(Index index) throws IOException {
        List properties;
        ArrayList<PropertyElement> result = new ArrayList<PropertyElement>();
        if (index != null && (properties = index.query(new String[]{"css.property"}, "*", 2)) != null) {
            for (QueryResult property : properties) {
                result.add(this.createProperty(property));
            }
        }
        return result;
    }

    public List<PropertyElement> getSubProperties(PropertyElement parentProperty) {
        return CSSIndexCacher.getInstance().getSubProperties(parentProperty);
    }

    public List<PropertyElement> getProperties(Index index, String ... names) throws IOException {
        ArrayList<PropertyElement> result = new ArrayList<PropertyElement>();
        if (index != null && names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                List properties = index.query(new String[]{"css.property"}, String.valueOf(name) + "\u0000", 1);
                if (properties != null) {
                    for (QueryResult property : properties) {
                        result.add(this.createProperty(property));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    public List<PseudoClassElement> getPseudoClasses(Index index) throws IOException {
        List pseudoClasses;
        ArrayList<PseudoClassElement> result = new ArrayList<PseudoClassElement>();
        if (index != null && (pseudoClasses = index.query(new String[]{"css.pseudo_class"}, "*", 2)) != null) {
            for (QueryResult pseudoClass : pseudoClasses) {
                result.add(this.createPseudoClass(pseudoClass));
            }
        }
        return result;
    }

    public List<PseudoElementElement> getPseudoElements(Index index) throws IOException {
        List pseudoElements;
        ArrayList<PseudoElementElement> result = new ArrayList<PseudoElementElement>();
        if (index != null && (pseudoElements = index.query(new String[]{"css.pseudo_element"}, "*", 2)) != null) {
            for (QueryResult pseudoElement : pseudoElements) {
                result.add(this.createPseudoElement(pseudoElement));
            }
        }
        return result;
    }

    protected String getSubDelimiter() {
        return ",";
    }

    public Map<String, String> getValues(Index index, String category) {
        String pattern;
        List items;
        HashMap<String, String> result = null;
        if (index != null && !StringUtil.isEmpty((String)category) && (items = index.query(new String[]{category}, pattern = "*", 2)) != null && items.size() > 0) {
            result = new HashMap<String, String>();
            for (QueryResult item : items) {
                Set paths = item.getDocuments();
                String path = paths != null && !paths.isEmpty() ? (String)paths.iterator().next() : "";
                result.put(item.getWord(), path);
            }
        }
        return result;
    }

    public Map<String, Set<String>> getSetValues(Index index, String category) {
        String pattern;
        List items;
        HashMap result = null;
        if (index != null && !StringUtil.isEmpty((String)category) && (items = index.query(new String[]{category}, pattern = "*", 2)) != null && items.size() > 0) {
            result = new HashMap();
            for (QueryResult item : items) {
                Set paths = item.getDocuments();
                for (String path : paths) {
                    HashSet<String> sets = (HashSet<String>)result.get(item.getWord());
                    if (sets == null) {
                        sets = new HashSet<String>();
                        result.put(item.getWord(), sets);
                    }
                    try {
                        URI uri = index.getRelativeDocumentPath(new URI(path));
                        sets.add(uri.toString());
                    }
                    catch (URISyntaxException e) {
                        IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                        sets.add(path);
                    }
                }
            }
        }
        return result;
    }
}

