/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist.index;

import com.aptana.build.util.BuildHelper;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.CSSColors;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.parsing.ast.CSSAttributeSelectorNode;
import com.aptana.editor.css.parsing.ast.CSSNode;
import com.aptana.editor.css.parsing.ast.CSSRuleNode;
import com.aptana.editor.css.parsing.ast.CSSTermNode;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class CSSFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    private static final Pattern fgHexColorPattern = Pattern.compile("^#[a-fA-F0-9]{3}([a-fA-F0-9]{3})?$");

    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                IParseRootNode ast = context.getAST();
                if (ast != null) {
                    int[] counts = new int[]{0};
                    this.walkNode(index, context.getURI(), (IParseNode)ast, context.isNeedSleep(), counts);
                }
            }
            catch (CoreException coreException) {
                sub.done();
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    public void walkNode(Index index, URI uri, IParseNode current, boolean isFullBuild, int[] counts) {
        CSSTermNode term;
        String value;
        if (current == null) {
            return;
        }
        if (isFullBuild) {
            counts[0] = counts[0] + 1;
            BuildHelper.sleepLoop((String)"CSS_INDEX_TYPE", (int)counts[0]);
        }
        if (current instanceof CSSAttributeSelectorNode) {
            CSSAttributeSelectorNode cssAttributeSelectorNode = (CSSAttributeSelectorNode)current;
            String text = cssAttributeSelectorNode.getText();
            if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '.') {
                this.addIndex(index, uri, "css.class", text.substring(1));
            } else if (!StringUtil.isEmpty((String)text) && text.charAt(0) == '#') {
                this.addIndex(index, uri, "css.identifier", text.substring(1));
            }
        }
        if (current instanceof CSSTermNode && CSSFileIndexingParticipant.isColor(value = (term = (CSSTermNode)current).getText())) {
            this.addIndex(index, uri, "css.color", CSSColors.to6CharHexWithLeadingHash(value.trim()));
        }
        if (current instanceof CSSRuleNode) {
            CSSNode child;
            CSSRuleNode cssRuleNode = (CSSRuleNode)current;
            CSSNode[] cSSNodeArray = cssRuleNode.getSelectors();
            int n = cSSNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = cSSNodeArray[n2];
                this.walkNode(index, uri, (IParseNode)child, isFullBuild, counts);
                ++n2;
            }
            cSSNodeArray = cssRuleNode.getDeclarations();
            n = cSSNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                child = cSSNodeArray[n2];
                this.walkNode(index, uri, (IParseNode)child, isFullBuild, counts);
                ++n2;
            }
        } else {
            IParseNode[] iParseNodeArray = current.getChildren();
            int n = iParseNodeArray.length;
            int n3 = 0;
            while (n3 < n) {
                IParseNode child = iParseNodeArray[n3];
                this.walkNode(index, uri, child, isFullBuild, counts);
                ++n3;
            }
        }
    }

    static boolean isColor(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        if (CSSColors.namedColorExists(value)) {
            return true;
        }
        if (value.charAt(0) == '#' && (value.length() == 4 || value.length() == 7)) {
            return fgHexColorPattern.matcher(value).matches();
        }
        return false;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return contextType == BuildContextType.CSS || contextType == BuildContextType.ALL;
    }
}

