/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.css.contentassist;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.css.CSSPlugin;
import com.aptana.editor.css.contentassist.index.CSSIndexReader;
import com.aptana.editor.css.contentassist.model.ElementElement;
import com.aptana.editor.css.contentassist.model.PropertyElement;
import com.aptana.editor.css.contentassist.model.PseudoClassElement;
import com.aptana.editor.css.contentassist.model.PseudoElementElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class CSSIndexQueryHelper {
    private CSSIndexReader _reader = new CSSIndexReader();
    protected static List<ElementElement> elementElementList = null;
    protected static List<PropertyElement> propertyElementList = null;
    protected static List<PseudoClassElement> pseudoClassElementList = null;
    protected static List<PseudoElementElement> pseudoElementElementList = null;

    public static Index getIndex() {
        return CSSIndexQueryHelper.getIndexManager().getIndex(URI.create("css.metadata:/css"));
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public Map<String, String> getClasses(Index index) {
        return this._reader.getValues(index, "css.class");
    }

    public Set<String> getColors(Index index) {
        Map<String, String> colorMap;
        if (index != null && (colorMap = this._reader.getValues(index, "css.color")) != null) {
            return colorMap.keySet();
        }
        return Collections.emptySet();
    }

    public ElementElement getElement(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        try {
            List<ElementElement> elements = this._reader.getElements(CSSIndexQueryHelper.getIndex(), name);
            if (!CollectionsUtil.isEmpty(elements)) {
                return elements.get(0);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public List<ElementElement> getElements() {
        try {
            if (elementElementList != null) {
                return elementElementList;
            }
            elementElementList = this._reader.getElements(CSSIndexQueryHelper.getIndex());
            return elementElementList;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<String, String> getIDs(Index index) {
        return this._reader.getValues(index, "css.identifier");
    }

    public List<PropertyElement> getProperties() {
        try {
            if (propertyElementList != null) {
                return propertyElementList;
            }
            propertyElementList = this._reader.getProperties(CSSIndexQueryHelper.getIndex());
            return propertyElementList;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PropertyElement getProperty(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        try {
            List<PropertyElement> properties = this._reader.getProperties(CSSIndexQueryHelper.getIndex(), name);
            if (!CollectionsUtil.isEmpty(properties)) {
                return properties.get(0);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public List<PropertyElement> getSubProperties(PropertyElement parentProperty) {
        return this._reader.getSubProperties(parentProperty);
    }

    public List<PseudoClassElement> getPseudoClasses() {
        try {
            if (pseudoClassElementList != null) {
                return pseudoClassElementList;
            }
            pseudoClassElementList = this._reader.getPseudoClasses(CSSIndexQueryHelper.getIndex());
            return pseudoClassElementList;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PseudoClassElement getPseudoClass(String name) {
        for (PseudoClassElement pce : this.getPseudoClasses()) {
            if (!ObjectUtil.areEqual((Object)name, (Object)pce.getName())) continue;
            return pce;
        }
        return null;
    }

    public List<PseudoElementElement> getPseudoElements() {
        try {
            if (pseudoElementElementList != null) {
                return pseudoElementElementList;
            }
            pseudoElementElementList = this._reader.getPseudoElements(CSSIndexQueryHelper.getIndex());
            return pseudoElementElementList;
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CSSPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public PseudoElementElement getPseudoElement(String name) {
        for (PseudoElementElement pee : this.getPseudoElements()) {
            if (!ObjectUtil.areEqual((Object)name, (Object)pee.getName())) continue;
            return pee;
        }
        return null;
    }

    public Map<String, Set<String>> getCSSReferences(Index index) {
        return this._reader.getSetValues(index, "html.resource.css");
    }
}

