/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views.action;

import com.aptana.editor.json.parsing.ast.JSONParseRootNode;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.ui.util.UIUtils;
import com.google.gson.Gson;
import com.pandora.core.appstream.AppStream;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.appstream.IAppStreamBuilder;
import com.pandora.core.appstream.Page;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.JSONUtils;
import com.pandora.editor.ui.editors.AppConfigEditor;
import com.pandora.editor.ui.editors.views.action.CheckIdleResourceDialog;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DefaultAppStreamBuilder
implements IAppStreamBuilder {
    public void buildAppStreamFile2Manifest(HMobileProject hMobile) {
        try {
            IProject project = hMobile.getProject();
            Gson gson = StreamJsonUtil.createGson();
            if (project != null) {
                IFile istreamFile = project.getFile("appstream.json");
                IFile iconfigFile = project.getFile("manifest.json");
                if (istreamFile.exists() && iconfigFile.exists()) {
                    File streamFile = istreamFile.getLocation().makeAbsolute().toFile();
                    File configFile = iconfigFile.getLocation().makeAbsolute().toFile();
                    String streamContent = FileUtils.readFileToString((File)streamFile);
                    String configContent = FileUtils.readFileToString((File)configFile);
                    AppStream appStream = (AppStream)gson.fromJson(streamContent, AppStream.class);
                    appStream.addPage(appStream.getMain().getHref(), appStream.getMain());
                    appStream.setWgt(null);
                    appStream.setUrl(null);
                    appStream.setProtocol(null);
                    appStream.setVersion(null);
                    appStream.setMain(null);
                    Map pages = appStream.getPages();
                    HashMap clone = new HashMap();
                    clone.putAll(pages);
                    for (Map.Entry entry : clone.entrySet()) {
                        appStream.addPage(((Page)entry.getValue()).getHref(), (Page)entry.getValue());
                    }
                    String json = gson.toJson((Object)appStream);
                    Map newMap = (Map)gson.fromJson(json, Map.class);
                    Map oldMap = (Map)gson.fromJson(configContent, Map.class);
                    if (oldMap.containsKey("dependencies")) {
                        Map depens = (Map)oldMap.get("dependencies");
                        StreamJsonUtil.unionDepens((Map)newMap, (Map)depens);
                        AppStreamFileBuilder builder = new AppStreamFileBuilder();
                        Map idle = builder.queryIdleResources(depens, project);
                        depens.put("idle", idle);
                        this.updateManifestJSON(depens, false, new StringBuffer(configContent), iconfigFile);
                    } else {
                        this.updateManifestJSON(newMap, true, new StringBuffer(configContent), iconfigFile);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateManifestJSON(Map depens, boolean create, StringBuffer document, IFile iconfigFile) {
        Gson gson = StreamJsonUtil.createGson();
        String content = gson.toJson((Object)depens);
        ParseResult result = null;
        try {
            result = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)document.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            return;
        }
        JSONParseRootNode root = (JSONParseRootNode)result.getRootNode();
        if (create) {
            IParseNode lastChild = JSONUtils.findJSONNodeByName(root, null);
            StringBuffer sBuffer = new StringBuffer();
            if (lastChild != null) {
                sBuffer.append(",\n\t").append("\"dependencies\"").append(":").append(content.replace("\n", "\n\t"));
                document.replace(lastChild.getEndingOffset() + 1, lastChild.getEndingOffset() + 1, sBuffer.toString());
            } else {
                LinkedHashMap<String, Map> map = new LinkedHashMap<String, Map>();
                map.put("dependencies", depens);
                document.replace(0, root.getLength(), gson.toJson(map));
            }
        } else {
            IParseNode lastChild = JSONUtils.findJSONNodeByName(root, "dependencies");
            document.replace(lastChild.getStartingOffset(), lastChild.getEndingOffset(), content);
        }
        this.writeContents(document.toString(), iconfigFile);
    }

    protected void writeContents(final String document, final IFile iconfigFile) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        ByteArrayInputStream input = new ByteArrayInputStream(document.getBytes(iconfigFile.getCharset()));
                        iconfigFile.setContents((InputStream)input, true, true, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean isNeedUserConfirm() {
        return false;
    }

    public IStatus prePublishCheck(HMobileProject hMobile, Dialog parentDialog) {
        IParseNode lastChild;
        IProject project = hMobile.getProject();
        IFile configFile = project.getFile("manifest.json");
        if (configFile == null) {
            return Status.CANCEL_STATUS;
        }
        Gson gson = StreamJsonUtil.createGson();
        IDocument document = null;
        boolean writeFile = true;
        try {
            AppConfigEditor appEditor = EditorPlugin.getAppConfigEditor(configFile);
            if (appEditor != null && appEditor.isDirty()) {
                document = appEditor.getSourceDocument();
                writeFile = false;
            } else {
                String content = StreamJsonUtil.getContents((IFile)configFile);
                document = new Document(content);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Map maniFestJSonMap = AppStreamFileBuilder.jsonToMap((IFile)configFile, (Gson)gson, document);
        if (!maniFestJSonMap.containsKey("dependencies")) {
            return Status.CANCEL_STATUS;
        }
        CheckIdleResourceDialog dialog = new CheckIdleResourceDialog(UIUtils.getActiveShell(), hMobile, maniFestJSonMap);
        dialog.setParentDialog(parentDialog);
        int select = dialog.open();
        if (select == 1) {
            return Status.CANCEL_STATUS;
        }
        Object[] elements = dialog.getCheckedElements();
        LinkedHashSet<String> unpackage = new LinkedHashSet<String>();
        if (maniFestJSonMap.containsKey("unpackage")) {
            Collection unpacks = (Collection)maniFestJSonMap.get("unpackage");
            unpackage.addAll(unpacks);
        }
        if (elements != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object el = objectArray[n2];
                if (el instanceof IFile) {
                    unpackage.add(((IFile)el).getProjectRelativePath().toString());
                }
                ++n2;
            }
        }
        ParseResult result = null;
        try {
            result = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)document.get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result == null) {
            return Status.OK_STATUS;
        }
        String replace = gson.toJson(unpackage).replace("\n", "\n\t");
        JSONParseRootNode root = (JSONParseRootNode)result.getRootNode();
        Point point = new Point(0, 0);
        if (maniFestJSonMap.containsKey("unpackage")) {
            lastChild = JSONUtils.findJSONNodeByName(root, "unpackage");
            point.x = lastChild.getStartingOffset();
            point.y = lastChild.getLength();
        } else {
            lastChild = JSONUtils.findJSONNodeByName(root, null);
            point.x = lastChild.getEndingOffset() + 1;
            point.y = 0;
            replace = ",\n\t\"unpackage\":" + replace;
        }
        try {
            document.replace(point.x, point.y, replace);
            if (writeFile) {
                this.writeContents(document.get(), configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }

    public String checkDuplicateKey(IFile manifest, final IDocument document) {
        if (document == null) {
            return "";
        }
        String content = document.get();
        try {
            String[] cgs = document.getPositionCategories();
            boolean isOpenedInEditor = cgs == null ? true : !Arrays.asList(cgs).contains("dependencies");
            ParseResult result = ParserPoolFactory.parse((String)"com.aptana.contenttype.json", (String)content);
            JSONParseRootNode root = (JSONParseRootNode)result.getRootNode();
            IParseNode node = JSONUtils.findJSONNodeByName(root, "dependencies");
            if (node == null) {
                return content;
            }
            if ((node = node.getParent()) == null) {
                return content;
            }
            IParseNode previousNode = node.getPreviousNode();
            int s = 0;
            s = previousNode != null ? previousNode.getStartingOffset() : node.getStartingOffset();
            final int start = s;
            final int end = node.getEndingOffset();
            if (isOpenedInEditor) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.replace(start, end - start + 1, "");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            document.replace(start, end - start + 1, "");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
                ByteArrayInputStream input = new ByteArrayInputStream(document.get().getBytes(manifest.getCharset()));
                manifest.setContents((InputStream)input, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document.get();
    }
}

