/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views.action;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.json.parsing.ast.JSONParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.project.HMobileProject;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.JSONUtils;
import com.pandora.editor.ui.MessageWithLinkDialog;
import com.pandora.editor.ui.editors.AppConfigEditor;
import com.pandora.editor.ui.editors.pages.JSONSourcePage;
import com.pandora.editor.ui.editors.views.CommonResourceFilter;
import com.pandora.editor.ui.editors.views.StreamResourceLabelProvider;
import com.pandora.editor.ui.editors.views.StreamViewerSorter;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class CheckIdleResourceDialog
extends Dialog {
    private static final String OPEN_STREAM_EDITOR_ACTION_MSG = "\u70b9\u6b64\u4fee\u6b63";
    private static final String OPEN_DEFINE_UNPACKAGE_ACTION_MSG = "\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f";
    private static final String OPEN_STREAM_SOURCE_EDITOR_ACTION_MSG = "\u70b9\u6b64\u6dfb\u52a0";
    private Map fManifest = null;
    private HMobileProject fMobileProject = null;
    private ContainerCheckedTreeViewer fContainerCheckedTreeViewer = null;
    private Dialog fParentDialog = null;
    private Object[] fCheckElements = null;

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "\u52a0\u5165unpackage\u6e05\u5355", true);
        this.createButton(parent, 1, "\u53d6\u6d88", false);
    }

    protected CheckIdleResourceDialog(Shell parentShell, HMobileProject mProject, Map manifest) {
        super(parentShell);
        this.fManifest = manifest;
        this.fMobileProject = mProject;
    }

    public void setParentDialog(Dialog pDialog) {
        this.fParentDialog = pDialog;
    }

    public ContainerCheckedTreeViewer getContainerCheckedTreeViewer() {
        return this.fContainerCheckedTreeViewer;
    }

    protected void okPressed() {
        if (this.fContainerCheckedTreeViewer != null) {
            this.fCheckElements = this.fContainerCheckedTreeViewer.getCheckedElements();
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(640, 600);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Collection idles;
        Map idleResources;
        parent.getShell().setText("\u6dfb\u52a0\u6587\u4ef6\u5230unpackage\u6e05\u5355");
        Composite container = (Composite)super.createDialogArea(parent);
        Link desc = new Link(container, 0);
        desc.setText("\u81ea\u52a8\u68c0\u6d4b\u5230\u7684\u672a\u4f7f\u7528\u6587\u4ef6\u3002(\u68c0\u6d4b\u7ed3\u679c\u4e0d\u6b63\u786e\uff1f<a>\u70b9\u6b64\u4fee\u6b63</a>)\u3002");
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)desc);
        this.fContainerCheckedTreeViewer = new ContainerCheckedTreeViewer(container, 65568);
        this.fContainerCheckedTreeViewer.setAutoExpandLevel(2);
        Map dependencies = (Map)this.fManifest.get("dependencies");
        if (dependencies.containsKey("idle") && (idleResources = (Map)dependencies.get("idle")).containsKey("resources") && (idles = (Collection)idleResources.get("resources")) != null && idles.size() > 30) {
            this.fContainerCheckedTreeViewer.setAutoExpandLevel(1);
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.fContainerCheckedTreeViewer.getControl());
        Tree tree = this.fContainerCheckedTreeViewer.getTree();
        tree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(tree, 16384);
        nameColumn.setText("\u8d44\u6e90\u540d\u79f0");
        nameColumn.setWidth(400);
        TreeColumn sizeColumn = new TreeColumn(tree, 16384);
        sizeColumn.setText("\u8d44\u6e90\u5927\u5c0f");
        sizeColumn.setWidth(120);
        this.fContainerCheckedTreeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fContainerCheckedTreeViewer.setLabelProvider((IBaseLabelProvider)new StreamResourceLabelProvider(dependencies));
        this.fContainerCheckedTreeViewer.setSorter((ViewerSorter)new StreamViewerSorter());
        final List idleResources2 = new AppStreamFileBuilder().getIdleResources(this.fMobileProject);
        this.fContainerCheckedTreeViewer.setFilters(new ViewerFilter[]{new CommonResourceFilter(), new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    IResource file = (IResource)element;
                    String filePath = file.getProjectRelativePath().toString();
                    if (idleResources2.contains(filePath)) {
                        return true;
                    }
                    if (file instanceof IFolder) {
                        for (String idle : idleResources2) {
                            if (!idle.startsWith(filePath)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }});
        this.fContainerCheckedTreeViewer.setInput((Object)this.fMobileProject.getProject());
        Link desc1 = new Link(container, 0);
        desc1.setText("\u8fd8\u6709\u5176\u4ed6\u6587\u4ef6\u4e0d\u6253\u5305\uff1f<a>\u70b9\u6b64\u6dfb\u52a0</a>\u3002");
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)desc);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)desc);
        if (this.fManifest.containsKey("unpackage")) {
            Collection unpackages = (Collection)this.fManifest.get("unpackage");
            ArrayList<IResource> resources = new ArrayList<IResource>();
            for (Object obj : unpackages) {
                IResource res;
                String filePath = obj.toString();
                if (!StringUtil.isNotBlank((String)filePath) || (res = this.fMobileProject.getProject().findMember(filePath)) == null || !res.exists()) continue;
                resources.add(res);
            }
            this.fContainerCheckedTreeViewer.setCheckedElements((Object[])resources.toArray(new IResource[resources.size()]));
        }
        desc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (CheckIdleResourceDialog.OPEN_STREAM_SOURCE_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openManifestEditor();
                    } else if (CheckIdleResourceDialog.OPEN_DEFINE_UNPACKAGE_ACTION_MSG.equals(e.text)) {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/480"));
                    } else if (CheckIdleResourceDialog.OPEN_STREAM_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openStreamEditor();
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        desc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (CheckIdleResourceDialog.OPEN_STREAM_SOURCE_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openManifestEditor();
                    } else if (CheckIdleResourceDialog.OPEN_DEFINE_UNPACKAGE_ACTION_MSG.equals(e.text)) {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/480"));
                    } else if (CheckIdleResourceDialog.OPEN_STREAM_EDITOR_ACTION_MSG.equals(e.text)) {
                        CheckIdleResourceDialog.this.openStreamEditor();
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        return container;
    }

    protected void openStreamEditor() throws Exception {
        IFile file = this.fMobileProject.getProject().getFile("manifest.json");
        IEditorPart part = IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)file, (boolean)true);
        if (part instanceof AppConfigEditor) {
            AppConfigEditor configEditor = (AppConfigEditor)part;
            configEditor.setActivePage("com.pandora.editor.appstream");
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5df2\u6253\u5f00\u9875\u9762\u5f15\u7528\u5173\u7cfb\uff0c\u5728\u5de6\u4fa7\u6811\u9009\u4e2d\u4e00\u4e2a\u9875\u9762\uff0c\u53f3\u4fa7\u5176\u4ed6\u8d44\u6e90\u5217\u8868\u4e2d\u5e26\"?\"\u89d2\u6807\u7684\u6587\u4ef6\u5373\u4e3a\u672a\u88ab\u4f7f\u7528\u7684\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3001\u914d\u7f6e\u8fd9\u4e9b\u6587\u4ef6\u7684\u5f15\u7528\u5173\u7cfb", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.open();
        }
    }

    protected void openManifestEditor() throws Exception {
        AppConfigEditor configEditor;
        IFormPage page;
        if (!this.fManifest.containsKey("unpackage")) {
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5f53\u524d\u6ca1\u6709\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff0c\u5982\u9700\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\u3002\u6559\u7a0b\u53c2\u8003<a>\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f</a>", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.create();
            dialog.getMessageLink().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/491"));
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                    }
                }
            });
            dialog.open();
            return;
        }
        IFile file = this.fMobileProject.getProject().getFile("manifest.json");
        IEditorPart part = IDE.openEditor((IWorkbenchPage)UIUtils.getActivePage(), (IFile)file, (boolean)true);
        if (part instanceof AppConfigEditor && (page = (configEditor = (AppConfigEditor)part).setActivePage("com.pandora.editor.appconfig.jsonsource")) instanceof JSONSourcePage) {
            JSONSourcePage sourcePage = (JSONSourcePage)page;
            IParseRootNode root = sourcePage.getSourceEditor().getAST();
            IParseNode node = JSONUtils.findJSONNodeByName((JSONParseRootNode)root, "unpackage");
            sourcePage.getSourceEditor().selectAndReveal(node.getStartingOffset() + 1, 0);
            sourcePage.getSourceEditor().setFocus();
            MessageWithLinkDialog dialog = new MessageWithLinkDialog(this.getParentShell(), "\u63d0\u793a", this.getParentShell().getImage(), "\u5df2\u6253\u5f00manifest.json\u4ee3\u7801\u89c6\u56fe,\u5176\u4e2dunpackage\u8282\u70b9\u4e2d\u8bb0\u5f55\u7684\u5373\u4e3aunpackage\u6587\u4ef6\u6e05\u5355\uff0c\u5982\u9700\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff0c\u8bf7\u53c2\u8003<a>\u5982\u4f55\u81ea\u5b9a\u4e49\u4e0d\u6253\u5305\u6587\u4ef6\uff1f</a>", 2, new String[]{"\u786e\u5b9a"}, 0);
            dialog.create();
            dialog.getMessageLink().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        Desktop.getDesktop().browse(URI.create("http://ask.dcloud.net.cn/article/491"));
                    }
                    catch (Exception ex) {
                        IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                    }
                }
            });
            dialog.open();
        }
    }

    public Object[] getCheckedElements() {
        return this.fCheckElements;
    }
}

