/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.pandora.core.CoreActivator;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.editors.views.ResourceSizeUtil;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.ResourceManager;

public class StreamResourceLabelProvider
extends WorkbenchLabelProvider
implements ITableLabelProvider {
    private Map fDependencies = null;
    private static ImageDescriptor idleImageOvr = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "icons/wen.png");
    private static ImageDescriptor imageIconDesc = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "icons/image.png");

    public StreamResourceLabelProvider(Map depens) {
        this.fDependencies = depens;
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        Map fIdle;
        if (!(element instanceof IResource)) {
            return input;
        }
        try {
            IResource res = (IResource)element;
            String fileExtension = res.getFileExtension();
            if (PlatformUtil.isWindows() && fileExtension != null && StringUtil.contains((String[])CoreActivator.imageExtensions, (String)fileExtension.toLowerCase()) && PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(((IFile)element).getName()) == WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE")) {
                input = imageIconDesc;
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
        if (CollectionsUtil.isEmpty((Map)this.fDependencies) || !this.fDependencies.containsKey("idle")) {
            if (element instanceof IFile) {
                return new DecorationOverlayIcon(input.createImage(), idleImageOvr, 3);
            }
            if (element instanceof IFolder) {
                return new DecorationOverlayIcon(input.createImage(), idleImageOvr, 3);
            }
        }
        if ((fIdle = (Map)this.fDependencies.get("idle")) != null && fIdle.containsKey("resources")) {
            IFolder folder;
            IFile file;
            List resources = (List)fIdle.get("resources");
            if (element instanceof IFile ? resources.contains((file = (IFile)element).getProjectRelativePath().toString()) : element instanceof IFolder && this.hasIdleResource(folder = (IFolder)element, resources)) {
                return new DecorationOverlayIcon(input.createImage(), idleImageOvr, 3);
            }
        }
        return input;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasIdleResource(IFolder folder, List resources) {
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource child = iResourceArray[n2];
                if (child instanceof IFolder) {
                    return this.hasIdleResource((IFolder)child, resources);
                }
                if (child instanceof IFile && resources.contains(child.getProjectRelativePath().toString())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected StyledString.Styler getDecorationStyle(Object element) {
        return super.getDecorationStyle(element);
    }

    protected String decorateText(String input, Object element) {
        return super.decorateText(input, element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (columnIndex == 1 && element instanceof IFile) {
            IFile file = (IFile)element;
            return ResourceSizeUtil.getStringSize(file, null);
        }
        return null;
    }
}

