/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ZipUtil;
import com.aptana.editor.common.contentassist.Helper;
import com.pandora.core.project.HMobileConvertor;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.editor.ui.editors.pages.AppStreamConfigPage;
import com.pandora.editor.ui.editors.views.CommonResourceFilter;
import com.pandora.editor.ui.editors.views.EditResourceMapAction;
import com.pandora.editor.ui.editors.views.FullNameLabelProvider;
import com.pandora.editor.ui.editors.views.IncludeContentListPart;
import com.pandora.editor.ui.editors.views.OtherContentTreePart;
import com.pandora.editor.ui.editors.views.OtherResourceFilter;
import com.pandora.editor.ui.editors.views.ResourceSizeUtil;
import com.pandora.editor.ui.editors.views.action.IAction;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.ResourceManager;

public class StreamPageDependenciesEditor {
    private Image leftArrowImage = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "/icons/arrow_left.png").createImage();
    private Image rightArrowImage = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "/icons/arrow_right.png").createImage();
    private Image upArrowImage = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "/icons/arrow_up.png").createImage();
    private Image downArrowImage = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "/icons/arrow_down.png").createImage();
    private static final long INDEX_PAGE_WARNING_SIZE = 153600L;
    private IFile fEditorInput = null;
    private IncludeContentListPart fIncludeResources = null;
    private IncludeContentListPart fIncludeLinks = null;
    private OtherContentTreePart fOtherResources = null;
    private EditResourceMapAction fEditAction = null;
    private Control fActiveControl = null;
    private AppStreamConfigPage fStreamPage = null;
    private Map fResourceDependencies = null;
    private Map fDiffDependencies = null;
    private Composite fContentComposite = null;
    private List<IAction> fServices = null;
    private boolean fCompress = false;

    public StreamPageDependenciesEditor(IFile editorInput, AppStreamConfigPage page) {
        this.fEditorInput = editorInput;
        this.fStreamPage = page;
        this.fEditAction = new EditResourceMapAction(this);
        this.fServices = new ArrayList<IAction>();
        try {
            HMobileProject project = HMobileConvertor.convert((IProject)this.getProject());
            String path = project.getAppConfig().getLaunch_path();
            if (this.getPath().equals(path)) {
                this.fCompress = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(Map dependencies, Map diffDependencies) {
        String selfSize;
        String template;
        this.fDiffDependencies = diffDependencies;
        if (CollectionsUtil.isNotEmpty((Map)dependencies)) {
            Map pages;
            String path = this.getPath();
            if (dependencies.containsKey("pages") && (pages = (Map)dependencies.get("pages")).containsKey(path)) {
                this.fResourceDependencies = (Map)pages.get(path);
            }
            if (CollectionsUtil.isNotEmpty((Map)this.fResourceDependencies)) {
                this.initResourcePart();
                this.initLinkPart();
            }
        }
        this.fOtherResources.setInput(this.getProject());
        if (this.fCompress) {
            if (this.fIncludeResources.getSizeInfoLabel() != null) {
                template = "\u81ea\u8eab\uff1a{0}\uff0c\u5305\u542b\u8d44\u6e90\uff1a{1}\uff0c\u9996\u9875\u8d44\u6e90\u538b\u7f29\u540e\uff1a\u6b63\u5728\u8ba1\u7b97...";
                selfSize = ResourceSizeUtil.getStringSize(this.getEditorInput(), null);
                String totalSize = ResourceSizeUtil.getStringSize(this.getIncludeResourceSpace(true));
                this.fIncludeResources.getSizeInfoLabel().setText(MessageFormat.format(template, selfSize, totalSize));
                this.fIncludeResources.getSizeInfoLabel().pack(true);
                this.asyncComputeResourceSize();
            }
        } else if (this.fIncludeResources.getSizeInfoLabel() != null) {
            template = "\u81ea\u8eab\uff1a{0}\uff0c\u5305\u542b\u8d44\u6e90\uff1a{1}";
            selfSize = ResourceSizeUtil.getStringSize(this.getEditorInput(), null);
            String totalSize = ResourceSizeUtil.getStringSize(this.getIncludeResourceSpace(false));
            this.fIncludeResources.getSizeInfoLabel().setText(MessageFormat.format(template, selfSize, totalSize));
            this.fIncludeResources.getSizeInfoLabel().pack(true);
        }
    }

    protected String getPath() {
        return this.fEditorInput.getLocation().makeRelativeTo(this.getProject().getLocation()).toString();
    }

    protected void initLinkPart() {
        Collection list = (Collection)this.fResourceDependencies.get("refer");
        ArrayList<IFile> res = new ArrayList<IFile>();
        if (CollectionsUtil.isNotEmpty((Collection)list)) {
            for (Object l : list) {
                IFile r = this.getProject().getFile(l.toString());
                if (!r.exists()) continue;
                res.add(r);
            }
        }
        this.fIncludeLinks.setLabelProvider((IBaseLabelProvider)new FullNameLabelProvider(this.fDiffDependencies, this.getPath(), false));
        this.fIncludeLinks.setInput(res.toArray(new IResource[res.size()]));
    }

    protected void initResourcePart() {
        Collection list = (Collection)this.fResourceDependencies.get("resources");
        ArrayList<IFile> res = new ArrayList<IFile>();
        if (CollectionsUtil.isNotEmpty((Collection)list)) {
            for (Object l : list) {
                IFile r = this.getProject().getFile(l.toString());
                if (!r.exists()) continue;
                res.add(r);
            }
        }
        this.fIncludeResources.setLabelProvider((IBaseLabelProvider)new FullNameLabelProvider(this.fDiffDependencies, this.getPath(), true));
        this.fIncludeResources.getLabelProvider().setPageDenpendencies(this.fStreamPage.getPageDependencies());
        this.fIncludeResources.setInput(res.toArray(new IResource[res.size()]));
    }

    public long getIncludeResourceSpace(boolean index) {
        long size = ResourceSizeUtil.getResourceSize(this.getEditorInput(), this.fStreamPage.getPageDependencies());
        size -= ResourceSizeUtil.getResourceSize(this.getEditorInput(), null);
        if (index) {
            size += ResourceSizeUtil.getResourceSize(this.getProject().getFile("manifest.json"), null);
        }
        return size;
    }

    public int getTextWidth(Control crl, String text) {
        GC gc = new GC((Drawable)crl);
        int width = 0;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            width += gc.getAdvanceWidth(c);
            ++i;
        }
        gc.dispose();
        return width;
    }

    public void createPartControl(Composite parent) {
        this.fContentComposite = parent;
        GridLayoutFactory.fillDefaults().margins(20, 0).spacing(10, 10).applyTo(parent);
        Composite head = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 30).applyTo((Control)head);
        head.setLayout((Layout)new FormLayout());
        this.createLocationBar(head);
        Label sep = new Label(parent, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sep);
        Composite rightPane = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightPane);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(10, 10).margins(20, 0).applyTo(rightPane);
        Composite left = new Composite(rightPane, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(400, 500).applyTo((Control)left);
        GridLayoutFactory.fillDefaults().spacing(10, 10).applyTo(left);
        this.createIncludeContent(left);
        Composite arrows = new Composite(rightPane, 0);
        GridDataFactory.fillDefaults().grab(false, true).hint(40, 0).applyTo((Control)arrows);
        GridLayoutFactory.fillDefaults().equalWidth(true).spacing(0, 40).applyTo(arrows);
        Composite resourceArrows = new Composite(arrows, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)resourceArrows);
        GridLayoutFactory.fillDefaults().applyTo(resourceArrows);
        Composite centerArrows = new Composite(resourceArrows, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(30, 80).applyTo((Control)centerArrows);
        GridLayoutFactory.fillDefaults().applyTo(centerArrows);
        Button leftBtn1 = new Button(centerArrows, 0x1800008);
        leftBtn1.setImage(this.leftArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)leftBtn1);
        Button rightBtn1 = new Button(centerArrows, 0x1800008);
        rightBtn1.setImage(this.rightArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightBtn1);
        Composite linkArrows = new Composite(arrows, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)linkArrows);
        GridLayoutFactory.fillDefaults().applyTo(linkArrows);
        Composite centerArrows2 = new Composite(linkArrows, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(30, 80).applyTo((Control)centerArrows2);
        GridLayoutFactory.fillDefaults().applyTo(centerArrows2);
        Button leftBtn2 = new Button(centerArrows2, 0x1800008);
        leftBtn2.setImage(this.leftArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)leftBtn2);
        Button rightBtn2 = new Button(centerArrows2, 0x1800008);
        rightBtn2.setImage(this.rightArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightBtn2);
        Composite right = new Composite(rightPane, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(350, 600).applyTo((Control)right);
        right.setLayout((Layout)new FillLayout());
        this.fOtherResources = new OtherContentTreePart("\u5176\u4ed6\u8d44\u6e90", "\u4e0d\u5728\u5305\u542b\u7684\u8d44\u6e90\u548c\u53ef\u4ece\u672c\u9875\u9762\u6253\u5f00\u7684\u4e0b\u7ea7\u9875\u9762\u4e2d\u7684\u672c\u9879\u76ee\u5176\u4ed6\u8d44\u6e90(\u5e26?\u89d2\u6807\u7684\u6587\u4ef6\u8868\u793a\u8be5\u6587\u4ef6\u6ca1\u6709\u88ab\u5176\u4ed6\u4efb\u4f55\u6587\u4ef6\u4f7f\u7528)", this.fStreamPage.getDependencies());
        this.fOtherResources.createPartControl(right);
        this.fOtherResources.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StreamPageDependenciesEditor.this.fActiveControl = StreamPageDependenciesEditor.this.fOtherResources.getControl();
                StreamPageDependenciesEditor.this.fActiveControl.setData("view", StreamPageDependenciesEditor.this.fOtherResources.getView());
            }
        });
        this.fOtherResources.setViewerFilter(new ViewerFilter[]{new OtherResourceFilter(this.getEditorInput(), this.fIncludeResources, this.fIncludeLinks), new CommonResourceFilter()});
        leftBtn1.setData("from", (Object)this.fOtherResources);
        leftBtn1.setData("to", (Object)this.fIncludeResources);
        rightBtn1.setData("from", (Object)this.fIncludeResources);
        rightBtn1.setData("to", (Object)this.fOtherResources);
        leftBtn2.setData("from", (Object)this.fOtherResources);
        leftBtn2.setData("to", (Object)this.fIncludeLinks);
        rightBtn2.setData("from", (Object)this.fIncludeLinks);
        rightBtn2.setData("to", (Object)this.fOtherResources);
        leftBtn1.addMouseListener((MouseListener)this.fEditAction);
        rightBtn1.addMouseListener((MouseListener)this.fEditAction);
        leftBtn2.addMouseListener((MouseListener)this.fEditAction);
        rightBtn2.addMouseListener((MouseListener)this.fEditAction);
        this.fIncludeResources.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StreamPageDependenciesEditor.this.openEditor();
            }
        });
        this.fIncludeLinks.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StreamPageDependenciesEditor.this.openEditor();
            }
        });
        this.fOtherResources.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StreamPageDependenciesEditor.this.openEditor();
            }
        });
    }

    protected void asyncComputeResourceSize() {
        Job job = new Job("compute file size..."){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet<String> resources = new HashSet<String>();
                resources.add("manifest.json");
                ResourceSizeUtil.collectResources(StreamPageDependenciesEditor.this.getEditorInput(), resources, StreamPageDependenciesEditor.this.fStreamPage.getPageDependencies());
                HashSet<String> compressFiles = new HashSet<String>();
                for (String res : resources) {
                    IFile file = StreamPageDependenciesEditor.this.getProject().getFile(res);
                    if (!file.exists()) continue;
                    compressFiles.add(file.getLocation().makeAbsolute().toFile().getAbsolutePath());
                }
                try {
                    File temp = File.createTempFile(UUID.randomUUID().toString(), null);
                    ZipUtil.compress((String)temp.getAbsolutePath(), (String[])compressFiles.toArray(new String[compressFiles.size()]));
                    final long length = temp.length();
                    final String compress = ResourceSizeUtil.getStringSize(length);
                    temp.delete();
                    StreamPageDependenciesEditor.this.fIncludeResources.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!Helper.okToUse((Widget)StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel())) {
                                return;
                            }
                            String text = StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel().getText();
                            text = text.replace("\u6b63\u5728\u8ba1\u7b97...", compress);
                            StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel().setText(text);
                            if (length >= 153600L) {
                                StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel().setForeground(StreamPageDependenciesEditor.this.fIncludeResources.getControl().getDisplay().getSystemColor(3));
                            } else {
                                StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel().setForeground(StreamPageDependenciesEditor.this.fIncludeResources.getControl().getDisplay().getSystemColor(2));
                            }
                            StreamPageDependenciesEditor.this.fIncludeResources.getSizeInfoLabel().pack();
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    protected void createLocationBar(Composite head) {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        IFile input = this.getEditorInput();
        Image image = labelProvider.getImage((Object)input);
        int leftMargin = 5;
        Label imageLabel = new Label(head, 0);
        FormData fData = new FormData(16, 20);
        fData.left = new FormAttachment(0, leftMargin);
        fData.top = new FormAttachment(0, 10);
        imageLabel.setLayoutData((Object)fData);
        imageLabel.setImage(image);
        Label textLabel = new Label(head, 0);
        textLabel.setText(input.getProjectRelativePath().toString());
        fData = new FormData(this.getTextWidth((Control)textLabel, textLabel.getText()), 20);
        fData.left = new FormAttachment((Control)imageLabel, 6);
        fData.top = new FormAttachment(0, 12);
        textLabel.setLayoutData((Object)fData);
        textLabel.pack(true);
    }

    protected void updateDiffDenpendencies(StructuredViewer viewer) {
        Object obj;
        if (viewer == null) {
            return;
        }
        IFile select = null;
        if (viewer.getSelection() instanceof IStructuredSelection && (obj = ((IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof IFile) {
            select = (IFile)obj;
        }
        if (select == null) {
            return;
        }
        Map pages = this.fStreamPage.getDiffDependencies();
        if (pages != null && pages.containsKey(this.getPath())) {
            Map page = (Map)pages.get(this.getPath());
            Collection list = null;
            boolean changed = false;
            boolean isEmpty = true;
            if (page.containsKey("refer")) {
                list = (Collection)page.get("refer");
                changed = list.remove(select.getProjectRelativePath().toString());
                isEmpty = list.isEmpty();
            }
            if (page.containsKey("resources")) {
                list = (Collection)page.get("resources");
                changed = list.remove(select.getProjectRelativePath().toString()) || changed;
                boolean bl = isEmpty = list.isEmpty() && isEmpty;
            }
            if (changed) {
                viewer.refresh();
                System.out.println("\u5237\u65b0\u65b0\u751f\u6210\u7684\u8d44\u6e90");
                if (isEmpty) {
                    pages.remove(this.getPath());
                    this.fStreamPage.getHTMLViewer().refresh();
                }
                try {
                    this.fStreamPage.getAppConfigEditor().setDirty(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void createIncludeContent(Composite left) {
        this.fIncludeResources = new IncludeContentListPart("\u672c\u9875\u9762\u5305\u542b\u7684\u8d44\u6e90", "\u542bjs\u3001css\u3001\u56fe\u7247\u3001\u5b57\u4f53\u3001\u7b2c\u4e00\u4e2a\u663e\u793a\u7684\u5b50webview\u9875\u9762\u3001iframe\u5185\u5d4c\u9875\u9762\u7b49\u3002");
        this.fIncludeResources.setContentType(IncludeContentListPart.ContentType.RESOURCE);
        this.fIncludeResources.createPartControl(left);
        this.fIncludeResources.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StreamPageDependenciesEditor.this.fActiveControl = StreamPageDependenciesEditor.this.fIncludeResources.getControl();
                StreamPageDependenciesEditor.this.fActiveControl.setData("view", StreamPageDependenciesEditor.this.fIncludeResources.getView());
                StreamPageDependenciesEditor.this.updateDiffDenpendencies((StructuredViewer)StreamPageDependenciesEditor.this.fIncludeResources.getView());
            }
        });
        Composite left_arrows = new Composite(left, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 40).applyTo((Control)left_arrows);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(left_arrows);
        Composite center = new Composite(left_arrows, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(100, 30).grab(true, true).applyTo((Control)center);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(20, 0).equalWidth(true).applyTo(center);
        Button upBtn = new Button(center, 0x1800008);
        upBtn.setImage(this.upArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)upBtn);
        Button downBtn = new Button(center, 0x1800008);
        downBtn.setImage(this.downArrowImage);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)downBtn);
        this.fIncludeLinks = new IncludeContentListPart("\u53ef\u4ece\u672c\u9875\u9762\u6253\u5f00\u7684\u4e0b\u7ea7\u9875\u9762", "\u4e0d\u542b\u5173\u95ed\u672c\u9875\u540e\u81ea\u52a8\u663e\u793a\u7684\u4e0a\u4e00\u4e2a\u9875\u9762");
        this.fIncludeLinks.setContentType(IncludeContentListPart.ContentType.LINK);
        this.fIncludeLinks.createPartControl(left);
        this.fIncludeLinks.addAcceptType("com.aptana.contenttype.html");
        this.fIncludeLinks.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                StreamPageDependenciesEditor.this.fActiveControl = StreamPageDependenciesEditor.this.fIncludeLinks.getControl();
                StreamPageDependenciesEditor.this.fActiveControl.setData("view", StreamPageDependenciesEditor.this.fIncludeLinks.getView());
                StreamPageDependenciesEditor.this.updateDiffDenpendencies((StructuredViewer)StreamPageDependenciesEditor.this.fIncludeLinks.getView());
            }
        });
        upBtn.setData("from", (Object)this.fIncludeLinks);
        upBtn.setData("to", (Object)this.fIncludeResources);
        upBtn.addMouseListener((MouseListener)this.fEditAction);
        downBtn.setData("from", (Object)this.fIncludeResources);
        downBtn.setData("to", (Object)this.fIncludeLinks);
        downBtn.addMouseListener((MouseListener)this.fEditAction);
    }

    public void write2SourceDocument(boolean refreshIdle) throws Exception {
        IResource[] incResources = this.fIncludeResources.getInput();
        IResource[] incLinks = this.fIncludeLinks.getInput();
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<String> link = new ArrayList<String>();
        IResource[] iResourceArray = incResources;
        int n = incResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            res.add(r.getProjectRelativePath().toString());
            ++n2;
        }
        iResourceArray = incLinks;
        n = incLinks.length;
        n2 = 0;
        while (n2 < n) {
            IResource l = iResourceArray[n2];
            link.add(l.getProjectRelativePath().toString());
            ++n2;
        }
        if (this.fResourceDependencies == null) {
            this.fResourceDependencies = StreamJsonUtil.createPage();
        }
        this.fResourceDependencies.put("resources", res);
        this.fResourceDependencies.put("refer", link);
        Map depends = this.fStreamPage.getDependencies();
        if (depends.containsKey("pages")) {
            Map pages = (Map)depends.get("pages");
            pages.put(this.fEditorInput.getProjectRelativePath().toString(), this.fResourceDependencies);
        } else {
            LinkedHashMap<String, Map> pages = new LinkedHashMap<String, Map>();
            pages.put(this.fEditorInput.getProjectRelativePath().toString(), this.fResourceDependencies);
            depends.put("pages", pages);
        }
        if (refreshIdle) {
            this.getStreamPage().computerIdle(this.fStreamPage.getDependencies());
        }
        this.fStreamPage.getAppConfigEditor().updateManifestJSON(this.fStreamPage.getDependencies());
    }

    public AppStreamConfigPage getStreamPage() {
        return this.fStreamPage;
    }

    protected IProject getProject() {
        return this.fEditorInput.getProject();
    }

    public IncludeContentListPart getResourcesPart() {
        return this.fIncludeResources;
    }

    public IncludeContentListPart getLinksPart() {
        return this.fIncludeLinks;
    }

    public void refresh() {
        if (this.fIncludeLinks != null) {
            this.fIncludeLinks.refresh();
        }
        if (this.fIncludeResources != null) {
            this.fIncludeResources.refresh();
        }
        if (this.fOtherResources != null) {
            this.fOtherResources.refresh();
        }
    }

    public IFile getEditorInput() {
        return this.fEditorInput;
    }

    public void dispose() {
        if (Helper.okToUse((Widget)this.fContentComposite)) {
            this.fContentComposite.dispose();
        }
    }

    public void addService(IAction service) {
        this.fServices.add(service);
    }

    protected void openEditor() {
        Object view;
        if (this.fActiveControl != null && (view = this.fActiveControl.getData("view")) instanceof StructuredViewer) {
            this.fStreamPage.openEditor((StructuredViewer)view);
        }
    }
}

