/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.aptana.core.util.ZipUtil;
import com.pandora.core.utils.CollectionsUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;

public class ResourceSizeUtil {
    public static final long EMPTY = 0L;

    public static void collectResources(IFile editorInput, Set<String> resources, Map pageDependencies) {
        Collection list;
        Map page;
        String pageKey = editorInput.getProjectRelativePath().toString();
        if (resources.contains(pageKey)) {
            return;
        }
        if (pageDependencies == null) {
            return;
        }
        resources.add(pageKey);
        if (pageDependencies.containsKey(pageKey) && (page = (Map)pageDependencies.get(pageKey)).containsKey("resources") && CollectionsUtil.isNotEmpty((Collection)(list = (Collection)page.get("resources")))) {
            for (Object res : list) {
                String resPath = res.toString();
                IFile input = editorInput.getProject().getFile(resPath);
                if (!input.exists()) continue;
                ResourceSizeUtil.collectResources(input, resources, pageDependencies);
            }
        }
    }

    public static long getResourceSize(IFile file, Map pageDenpendencies) {
        if (file == null) {
            return 0L;
        }
        if (pageDenpendencies != null) {
            HashSet<String> resources = new HashSet<String>();
            ResourceSizeUtil.collectResources(file, resources, pageDenpendencies);
            long size = 0L;
            for (String res : resources) {
                IFile input = file.getProject().getFile(res);
                size += ResourceSizeUtil.getResourceSize(input, null);
            }
            return size;
        }
        File f = file.getLocation().makeAbsolute().toFile();
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static String getStringSize(IFile file, Map pageDenpendencies) {
        return ResourceSizeUtil.getStringSize(ResourceSizeUtil.getResourceSize(file, pageDenpendencies));
    }

    public static String getStringSize(long space) {
        DecimalFormat df = new DecimalFormat("#.##");
        if (space < 1024L) {
            return String.valueOf(space) + "B";
        }
        if (space < 0x100000L) {
            return String.valueOf(df.format((float)space / 1024.0f)) + "KB";
        }
        if (space < 0x40000000L) {
            return String.valueOf(df.format((float)space / 1048576.0f)) + "MB";
        }
        return String.valueOf(df.format((float)space / 1.0737418E9f)) + "GB";
    }

    public static long getResourceZipedSize(IFile file) {
        if (file == null) {
            return 0L;
        }
        try {
            File f = file.getLocation().makeAbsolute().toFile();
            File temp = File.createTempFile("ziped_resource_" + file.getName(), null);
            ZipUtil.compress((String)temp.getAbsolutePath(), (String[])new String[]{f.getAbsolutePath()});
            return temp.length();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

