/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.pandora.editor.ui.editors.views.FullNameLabelProvider;
import com.pandora.editor.ui.editors.views.IMoveableResource;
import com.pandora.editor.ui.editors.views.ListResourceContentProvider;
import com.pandora.editor.ui.editors.views.StreamViewerSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class IncludeContentListPart
implements IMoveableResource {
    private String fTitle = null;
    private String fDesc = null;
    private TableViewer fTableViewer = null;
    private List<IResource> fInput = null;
    private ContentType fContentType = null;
    private Label fSizeInfoLabel = null;
    private Set<String> fAcceptTypes = new HashSet<String>();

    public IncludeContentListPart(String title, String desc) {
        this.fTitle = title;
        this.fDesc = desc;
        this.fInput = new ArrayList<IResource>();
    }

    public void setContentType(ContentType type) {
        this.fContentType = type;
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(0, 250).applyTo((Control)content);
        content.setLayout((Layout)new FillLayout());
        Group partGroup = new Group(content, 0);
        partGroup.setText(this.fTitle);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)partGroup);
        Label desc = new Label((Composite)partGroup, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(0, 35).applyTo((Control)desc);
        desc.setText(this.fDesc);
        Composite comp = new Composite((Composite)partGroup, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        TableColumnLayout tableLayout = new TableColumnLayout();
        comp.setLayout((Layout)tableLayout);
        this.fTableViewer = new TableViewer(comp, 65538);
        this.fTableViewer.getTable().setHeaderVisible(true);
        TableColumn resourceName = new TableColumn(this.fTableViewer.getTable(), 0);
        tableLayout.setColumnData((Widget)resourceName, (ColumnLayoutData)new ColumnWeightData(80, false));
        resourceName.setText("\u8d44\u6e90\u540d\u79f0");
        if (this.fContentType == ContentType.RESOURCE) {
            resourceName = new TableColumn(this.fTableViewer.getTable(), 0);
            tableLayout.setColumnData((Widget)resourceName, (ColumnLayoutData)new ColumnWeightData(20, 150, false));
            resourceName.setText("\u5927\u5c0f");
            this.fSizeInfoLabel = new Label((Composite)partGroup, 64);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, -1).applyTo((Control)this.fSizeInfoLabel);
        }
        this.fTableViewer.setContentProvider((IContentProvider)new ListResourceContentProvider());
        this.fTableViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof IFolder);
            }
        }});
        this.fTableViewer.getTable().setBackground(parent.getDisplay().getSystemColor(1));
        this.fTableViewer.setSorter((ViewerSorter)new StreamViewerSorter());
    }

    public Label getSizeInfoLabel() {
        return this.fSizeInfoLabel;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fTableViewer.setLabelProvider(labelProvider);
    }

    public void addAcceptType(String contentType) {
        this.fAcceptTypes.add(contentType);
    }

    public void setInput(IResource[] resources) {
        this.fInput.clear();
        this.fInput.addAll(Arrays.asList(resources));
        this.fTableViewer.setInput((Object)resources);
    }

    public Control getControl() {
        return this.fTableViewer.getControl();
    }

    public IResource[] getInput() {
        IResource[] result = (IResource[])this.fTableViewer.getInput();
        if (result == null) {
            return new IResource[0];
        }
        return result;
    }

    @Override
    public IResource[] getSelectionResources() {
        IStructuredSelection structSelection;
        Object[] objs;
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection && (objs = (structSelection = (IStructuredSelection)selection).toArray()) != null && objs.length > 0) {
            IResource[] results = new IResource[objs.length];
            int i = 0;
            while (i < objs.length) {
                results[i] = (IResource)objs[i];
                ++i;
            }
            return results;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.fTableViewer.setInput((Object)this.fInput.toArray(new IResource[this.fInput.size()]));
    }

    @Override
    public boolean removeResources(IResource[] resources) {
        this.fInput.removeAll(Arrays.asList(resources));
        try {
            this.updateDiffDependencies(resources);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void updateDiffDependencies(IResource[] resources) {
        FullNameLabelProvider provider = this.getLabelProvider();
        Map diffs = provider.getDiffDependencies();
        if (diffs != null && diffs.containsKey(provider.getPagePath())) {
            IResource res;
            int n;
            int n2;
            IResource[] iResourceArray;
            Collection list;
            Map page = (Map)diffs.get(provider.getPagePath());
            if (page.containsKey("resources") && (list = (Collection)page.get("resources")) != null) {
                iResourceArray = resources;
                n2 = resources.length;
                n = 0;
                while (n < n2) {
                    res = iResourceArray[n];
                    list.remove(res.getProjectRelativePath().toString());
                    ++n;
                }
            }
            if (page.containsKey("refer") && (list = (Collection)page.get("refer")) != null) {
                iResourceArray = resources;
                n2 = resources.length;
                n = 0;
                while (n < n2) {
                    res = iResourceArray[n];
                    list.remove(res.getProjectRelativePath().toString());
                    ++n;
                }
            }
        }
    }

    public FullNameLabelProvider getLabelProvider() {
        if (this.fTableViewer.getLabelProvider() instanceof FullNameLabelProvider) {
            return (FullNameLabelProvider)this.fTableViewer.getLabelProvider();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IResource[] addResources(IResource[] resources) {
        manager = Platform.getContentTypeManager();
        list = new ArrayList<IResource>();
        ignores = new ArrayList<IResource>();
        var8_5 = resources;
        var7_6 = resources.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block4: {
                res = var8_5[var6_7];
                if (res instanceof IFolder) break block4;
                if (this.fAcceptTypes.isEmpty()) ** GOTO lbl18
                type = manager.findContentTypeFor(res.getName());
                if (type == null || !this.fAcceptTypes.contains(type.getId())) {
                    ignores.add(res);
                } else {
                    list.add(res);
lbl18:
                    // 2 sources

                    this.fInput.add(res);
                }
            }
            ++var6_7;
        }
        if (!ignores.isEmpty()) {
            dialog = new MessageDialog(this.getControl().getShell(), "\u9875\u9762\u5f15\u7528\u5173\u7cfb", this.getControl().getShell().getImage(), "\u4ec5\u80fd\u6dfb\u52a0HTML\u7c7b\u7684\u6587\u4ef6\u5230\u3010" + this.fTitle + "\u3011", 4, new String[]{"\u786e\u5b9a"}, 0);
            dialog.open();
            return list.toArray(new IResource[list.size()]);
        }
        return resources;
    }

    public Object getView() {
        return this.fTableViewer;
    }

    public static enum ContentType {
        RESOURCE,
        LINK;

    }
}

