/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class HTMLViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            return this.isHTMLContentType(file);
        }
        if (element instanceof IFolder) {
            IFolder folder;
            block6: {
                folder = (IFolder)element;
                if ("unpackage".equals(folder.getName()) && folder.getParent() instanceof IProject) {
                    return false;
                }
                try {
                    if (folder.members().length != 0) break block6;
                    return false;
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
                    return false;
                }
            }
            return this.hasHTMLInFolder(folder);
        }
        return true;
    }

    protected boolean isHTMLContentType(IFile file) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
        return contentType != null && "com.aptana.contenttype.html".equals(contentType.getId());
    }

    protected boolean hasHTMLInFolder(IFolder folder) throws CoreException {
        IResource[] resources = folder.members();
        if (resources == null) {
            return false;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            boolean isHTML;
            boolean hasHTML;
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder ? (hasHTML = this.hasHTMLInFolder((IFolder)res)) : res instanceof IFile && (isHTML = this.isHTMLContentType(file = (IFile)res))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

