/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.views;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.pandora.core.CoreActivator;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.editors.views.ResourceSizeUtil;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.ResourceManager;

public class FullNameLabelProvider
extends LabelProvider
implements ITableFontProvider,
ITableLabelProvider {
    private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private Map fDiffDependencies = null;
    private Map fPageDenpendencies = null;
    private String fPagePath = null;
    private boolean isResource = false;
    private static ImageDescriptor imageIconDesc = ResourceManager.getPluginImageDescriptor("com.pandora.editor.ui", "icons/image.png");

    public FullNameLabelProvider(Map diffDependencies, String pagePath, boolean isResource) {
        this.fDiffDependencies = diffDependencies;
        this.fPagePath = pagePath;
        this.isResource = isResource;
    }

    public void setPageDenpendencies(Map pageDenpendencies) {
        this.fPageDenpendencies = pageDenpendencies;
    }

    public String getText(Object element) {
        if (element instanceof IFile) {
            IFile f = (IFile)element;
            String path = f.getProjectRelativePath().toString();
            return path;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IResource) {
            try {
                IResource res = (IResource)element;
                String fileExtension = res.getFileExtension();
                if (PlatformUtil.isWindows() && fileExtension != null && StringUtil.contains((String[])CoreActivator.imageExtensions, (String)fileExtension.toLowerCase()) && PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(((IFile)element).getName()) == WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE")) {
                    return imageIconDesc.createImage();
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        return this.workbenchLabelProvider.getImage(element);
    }

    public Font getFont(Object element, int columnIndex) {
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource res = (IResource)element;
        if (this.fDiffDependencies != null && this.fDiffDependencies.containsKey(this.fPagePath)) {
            Collection list;
            Map pageDependency = (Map)this.fDiffDependencies.get(this.fPagePath);
            if (this.isResource ? pageDependency.containsKey("resources") && (list = (Collection)pageDependency.get("resources")).contains(res.getProjectRelativePath().toString()) : pageDependency.containsKey("refer") && (list = (Collection)pageDependency.get("refer")).contains(res.getProjectRelativePath().toString())) {
                return new FontRegistry().getBold(this.getSystemFontName());
            }
        }
        return null;
    }

    protected String getSystemFontName() {
        return Display.getDefault().getSystemFont().getFontData()[0].getName();
    }

    public String getPagePath() {
        return this.fPagePath;
    }

    public Map getDiffDependencies() {
        return this.fDiffDependencies;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(element);
        }
        if (1 == columnIndex && element instanceof IFile) {
            IFile file = (IFile)element;
            if (StreamJsonUtil.isPageContentType((IFile)file)) {
                long selfSize = ResourceSizeUtil.getResourceSize(file, null);
                String selfSizeStr = ResourceSizeUtil.getStringSize(selfSize);
                long totalSize = ResourceSizeUtil.getResourceSize(file, this.fPageDenpendencies);
                String totalSizeStr = ResourceSizeUtil.getStringSize(totalSize - selfSize);
                return String.valueOf(selfSizeStr) + "/" + totalSizeStr + "(\u5305\u542b\u8d44\u6e90\u5927\u5c0f)";
            }
            return ResourceSizeUtil.getStringSize((IFile)element, this.fPageDenpendencies);
        }
        return null;
    }
}

