/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.pandora.editor.ui.editors.JSONSourceEditor;
import com.pandora.ui.UiActivator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class JSONSourcePage
extends FormPage {
    private JSONSourceEditor sourceEditor = null;
    private Map<String, IAction> actionMap = new HashMap<String, IAction>();

    public JSONSourcePage(FormEditor editor, String id, String title, JSONSourceEditor sourceEditor) {
        super(editor, id, title);
        this.sourceEditor = sourceEditor;
    }

    public JSONSourceEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public void init(IEditorSite site, IEditorInput input) {
        try {
            this.sourceEditor.init(site, input);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)UiActivator.getDefault(), (Throwable)e);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        if (this.sourceEditor != null) {
            Composite parent = managedForm.getForm().getBody();
            parent.setLayout((Layout)new FillLayout());
            this.sourceEditor.createPartControl(parent);
            parent.layout();
            if (this.actionMap.isEmpty()) {
                try {
                    Field field = AbstractTextEditor.class.getDeclaredField("fActions");
                    field.setAccessible(true);
                    Map fActions = (Map)field.get((Object)this.sourceEditor);
                    for (Object actionId : fActions.keySet()) {
                        this.actionMap.put((String)actionId, (IAction)fActions.get(actionId));
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)UiActivator.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public void setActionsEnable(boolean enable) {
        if (this.actionMap.isEmpty()) {
            return;
        }
        if (!enable) {
            for (String id : this.actionMap.keySet()) {
                this.sourceEditor.setAction(id, null);
            }
            this.sourceEditor.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.UNDO, null);
            this.sourceEditor.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.REDO, null);
        } else {
            this.sourceEditor.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.actionMap.get(ITextEditorActionConstants.UNDO));
            this.sourceEditor.getEditorSite().getActionBars().setGlobalActionHandler(ITextEditorActionConstants.REDO, this.actionMap.get(ITextEditorActionConstants.REDO));
            for (String id : this.actionMap.keySet()) {
                this.sourceEditor.setAction(id, this.actionMap.get(id));
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.sourceEditor != null) {
            try {
                this.sourceEditor.dispose();
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)UiActivator.getDefault(), (Throwable)e);
            }
        }
    }
}

