/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.logging.IdeLog;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.core.mobile.model.ManifastConfiguration;
import com.pandora.core.utils.StringUtil;
import com.pandora.editor.ui.EditorPlugin;
import com.pandora.editor.ui.editors.pages.AbstractAppConfigPage;
import com.pandora.ui.NewUserLoginDialog;
import com.pandora.ui.widget.PrettyToggleButton;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wb.swt.ResourceManager;

public class BasicInfoAppConfigPage
extends AbstractAppConfigPage {
    private static final int H_MARGIN = 40;
    private static final int V_MARGIN = 10;
    private static final int H_SPACE = 15;
    private static final int V_SPACE = 20;
    private Text appnameText;
    private Text appidText;
    private Button getAppidButton;
    private Text versionText;
    private Text homePageText;
    private Button fullscreenCheck;
    private Button debugCheck;
    private Button runmodeLiberateRadio;
    private Button runmodeNormalRadio;
    private Button disableRamCacheRadio;
    private Button enableRamCacheRadio;
    private Button portraitCheck;
    private Button upsideDownCheck;
    private Button landscapeLeftCheck;
    private Button landscapeRightCheck;
    private Label runmodeLabel;
    private Label ramcacheLabel;
    private PrettyToggleButton portraitButton;
    private PrettyToggleButton upsideDownButton;
    private PrettyToggleButton landscapeLeftButton;
    private PrettyToggleButton landscapeRightButton;
    private Group orientationGroup;

    public BasicInfoAppConfigPage(FormEditor editor, String id, String title, String titleLinkText, URL titleLinkUrl, JSONObject pageConfig) {
        super(editor, id, title, titleLinkText, titleLinkUrl, pageConfig);
    }

    @Override
    protected void createPageContent(IManagedForm managedForm) {
        FormToolkit formToolkit = managedForm.getToolkit();
        this.createBaiscInfoContent(formToolkit);
        this.createOrientationInfoContent(formToolkit);
        this.bindErrorDecorations(formToolkit);
    }

    private void createBaiscInfoContent(FormToolkit formToolkit) {
        Composite noticeComposite = formToolkit.createComposite(this.bodyContent);
        noticeComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 10).create());
        noticeComposite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Label noticeText = new Label(noticeComposite, 72);
        noticeText.setText("\u6ce8\uff1amanifest\u91cc\u5927\u90e8\u5206\u914d\u7f6e\u5728\u771f\u673a\u8fd0\u884c\u65f6\u662f\u4e0d\u751f\u6548\u7684,\u751f\u6548\u7684\u90e8\u5206\u4ee5\u84dd\u8272\u5b57\u4f53\u8868\u793a,\u5176\u4ed6\u90e8\u5206\u9700\u8981\u901a\u8fc7App\u6253\u5305\u624d\u53ef\u770b\u5230\u6548\u679c");
        noticeText.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).grab(true, true).create());
        Group group = this.createGroup("\u57fa\u672c\u4fe1\u606f", noticeComposite, formToolkit);
        Composite textlist = formToolkit.createComposite((Composite)group);
        textlist.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        textlist.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(40, 40, 10, 20).spacing(15, 20).create());
        Label appnameLabel = formToolkit.createLabel(textlist, "\u5e94\u7528\u540d\u79f0:");
        appnameLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.appnameText = formToolkit.createText(textlist, "", 0);
        this.appnameText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        Label appidLabel = formToolkit.createLabel(textlist, "appid:");
        appidLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.appidText = formToolkit.createText(textlist, "", 0);
        this.appidText.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.getAppidButton = formToolkit.createButton(textlist, "\u4e91\u7aef\u83b7\u53d6", 0);
        this.getAppidButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.getAppidButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (UserAuth.isLoginSucess() != 1) {
                    NewUserLoginDialog window = new NewUserLoginDialog(Display.getDefault().getActiveShell());
                    window.open();
                }
                if (UserAuth.isLoginSucess() != 1) {
                    MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), "\u9519\u8bef", null, "\u8bf7\u5148\u767b\u5f55\u518d\u4f7f\u7528\u4e91\u7aef\u83b7\u53d6Appid\u529f\u80fd", 3, new String[]{IDialogConstants.OK_LABEL}, 1);
                    dialog.open();
                    return;
                }
                String command = "ProjectAction!applyProject";
                HttpClientUtils client = HttpClientUtils.getInstance((String)command);
                try {
                    client.addRequestBody("appname", BasicInfoAppConfigPage.this.getEditor().getProject().getDescription().getName());
                }
                catch (CoreException coreException) {}
                try {
                    ResponseObj rsp = client.excute();
                    if ("1001".equals(rsp.getRspcode())) {
                        BasicInfoAppConfigPage.this.appidText.setText(rsp.getValueByKey("appid"));
                        BasicInfoAppConfigPage.this.appidText.forceFocus();
                    } else {
                        "999".equals(rsp.getRspcode());
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.appidText.setToolTipText("\u53ea\u6709Appid\u4e3a\u7a7a\u4e14\u6b63\u5e38\u767b\u5f55\u7684\u7528\u6237\u624d\u53ef\u4ee5\u4f7f\u7528\u4e91\u7aef\u83b7\u53d6\u529f\u80fd");
        this.getAppidButton.setToolTipText("\u53ea\u6709Appid\u4e3a\u7a7a\u4e14\u6b63\u5e38\u767b\u5f55\u7684\u7528\u6237\u624d\u53ef\u4ee5\u4f7f\u7528\u6b64\u529f\u80fd");
        Label versionLabel = formToolkit.createLabel(textlist, "\u7248\u672c\u53f7:");
        versionLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        versionLabel.setForeground(this.realTimeColor);
        this.versionText = formToolkit.createText(textlist, "", 0);
        this.versionText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).create());
        Label homePageLabel = formToolkit.createLabel(textlist, "\u9875\u9762\u5165\u53e3:");
        homePageLabel.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        homePageLabel.setForeground(this.realTimeColor);
        this.homePageText = formToolkit.createText(textlist, "", 0);
        this.homePageText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.homePageText.setDoubleClickEnabled(false);
        this.homePageText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    String text = BasicInfoAppConfigPage.this.homePageText.getText();
                    if (text != null) {
                        int end = text.lastIndexOf(46);
                        if (end > 0) {
                            BasicInfoAppConfigPage.this.homePageText.setSelection(0, end);
                        } else {
                            BasicInfoAppConfigPage.this.homePageText.selectAll();
                        }
                    }
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                    BasicInfoAppConfigPage.this.homePageText.selectAll();
                }
            }
        });
        Button selectFileButton = formToolkit.createButton(textlist, "  \u9009\u62e9...  ", 0);
        selectFileButton.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        selectFileButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object obj;
                ElementTreeSelectionDialog fileDialog = new ElementTreeSelectionDialog(BasicInfoAppConfigPage.this.getSite().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                fileDialog.setInput((Object)BasicInfoAppConfigPage.this.getEditor().getProject());
                fileDialog.setInitialSelection(null);
                fileDialog.setDoubleClickSelects(true);
                fileDialog.setTitle("\u8bf7\u9009\u62e9\u4e00\u4e2a\u5165\u53e3\u9875\u9762");
                fileDialog.setAllowMultiple(false);
                ViewerFilter filter = new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element != null) {
                            if (element instanceof IFile) {
                                return element.toString().endsWith(".html");
                            }
                            if (element instanceof IFolder) {
                                return true;
                            }
                        }
                        return false;
                    }
                };
                fileDialog.addFilter(filter);
                fileDialog.setMessage("\u8bf7\u9009\u62e9\u4e00\u4e2a\u5165\u53e3\u9875\u9762");
                if (fileDialog.open() == 0 && (obj = fileDialog.getFirstResult()) instanceof IFile) {
                    IFile file = (IFile)obj;
                    BasicInfoAppConfigPage.this.homePageText.setText(file.getProjectRelativePath().toString());
                }
            }
        });
        Composite checklist = formToolkit.createComposite((Composite)group, 0);
        checklist.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.spacing = 20;
        rowLayout.marginBottom = 10;
        rowLayout.marginWidth = 40;
        checklist.setLayout((Layout)rowLayout);
        String tip = "\u5168\u5c4f\u663e\u793a\u7684\u5e94\u7528\u4e0d\u663e\u793a\u9876\u90e8\u7cfb\u7edf\u72b6\u6001\u680f\u5982\u4fe1\u53f7\u5f3a\u5ea6\u3001\u7535\u91cf\u7b49\uff0c\u975e\u5168\u5c4f\u663e\u793a\u7684\u5e94\u7528\u5219\u663e\u793a\u9876\u90e8\u7cfb\u7edf\u72b6\u6001\u680f";
        this.fullscreenCheck = this.createCheckBox(checklist, "\u5e94\u7528\u662f\u5426\u5168\u5c4f\u663e\u793a", tip, 32, formToolkit);
        this.fullscreenCheck.setForeground(this.realTimeColor);
        this.debugCheck = formToolkit.createButton(checklist, "debug\u6a21\u5f0f (android\u662f\u5426\u652f\u6301\u65e5\u5fd7\u8f93\u51fa\u53cachrome\u8c03\u8bd5)", 32);
        this.debugCheck.setToolTipText("\u4e0d\u52fe\u9009\u6b64\u9879\u6253\u5305\u540e\u7684apk\u4e0d\u751f\u6210\u65e5\u5fd7\u6587\u4ef6");
        Composite lineComposite = formToolkit.createComposite(checklist, 0);
        lineComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(15, -1).create());
        this.runmodeLabel = formToolkit.createLabel(lineComposite, "\u5e94\u7528\u8d44\u6e90\u662f\u5426\u89e3\u538b");
        this.runmodeNormalRadio = formToolkit.createButton(lineComposite, "\u4e0d\u89e3\u538b\u76f4\u63a5\u8fd0\u884c", 16);
        this.runmodeNormalRadio.setToolTipText("Android\u5e73\u53f0\u5728\u6b64\u65b9\u5f0f\u4e0b\u4e0d\u53ef\u901a\u8fc75+Api\u7684plus.io.*\u8bbf\u95ee\u5e94\u7528\u8d44\u6e90\uff0c\u540c\u65f6\u5728Android4.0\u30014.1\u7684\u7cfb\u7edf\u4e0a,\u8bbf\u95ee\u7684\u9875\u9762\u5730\u5740\u4e2d\u5982\u679c\u5e26\u53c2\u6570\u4ee5\u6b64\u65b9\u5f0f\u8fd0\u884c\u4e0d\u53ef\u6b63\u5e38\u4f7f\u7528");
        this.runmodeLiberateRadio = formToolkit.createButton(lineComposite, "\u89e3\u538b\u8d44\u6e90\u540e\u8fd0\u884c", 16);
        this.runmodeLiberateRadio.setToolTipText("Android\u5e73\u53f0\u5728\u6b64\u65b9\u5f0f\u4e0b\u624d\u53ef\u901a\u8fc75+Api\u7684plus.io.*\u8bbf\u95ee\u5e94\u7528\u8d44\u6e90\uff0c\u540c\u65f6\u5728Android4.0\u30014.1\u7684\u7cfb\u7edf\u4e0a,\u8bbf\u95ee\u7684\u9875\u9762\u5730\u5740\u4e2d\u5982\u679c\u5e26\u53c2\u6570\u5fc5\u987b\u662f\u4ee5\u6b64\u65b9\u5f0f\u8fd0\u884c\u624d\u53ef\u6b63\u5e38\u4f7f\u7528\u3002\u4f46\u6b64\u6a21\u5f0f\u4e0b\u4f1a\u5bfc\u81f4\u5e94\u7528\u7b2c\u4e00\u6b21\u542f\u52a8\u901f\u5ea6\u6162\uff0c\u4e0d\u63a8\u8350!");
        Composite cacheComposite = formToolkit.createComposite(checklist, 0);
        cacheComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(15, -1).create());
    }

    private Button createCheckBox(Composite parent, String text, String tip, int style, FormToolkit formToolkit) {
        Composite checkBoxComposite = formToolkit.createComposite(parent, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.marginLeft = 0;
        checkBoxComposite.setLayout((Layout)rowLayout);
        final Button button = new Button(checkBoxComposite, style);
        Label label = formToolkit.createLabel(checkBoxComposite, text, 0);
        button.setData("label", (Object)label);
        label.setForeground(this.realTimeColor);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                button.setSelection(!button.getSelection());
                Event event = new Event();
                event.widget = e.widget;
                event.type = 13;
                button.notifyListeners(13, event);
            }
        });
        if (tip != null) {
            button.setToolTipText(tip);
            label.setToolTipText(tip);
        }
        Hyperlink link = formToolkit.createHyperlink(checkBoxComposite, "\u5e94\u7528\u5168\u5c4f\u914d\u7f6e\u8bf4\u660e", 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(URI.create("http://ask.dcloud.net.cn/article/32").toURL());
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)EditorPlugin.getDefault(), (Throwable)ex);
                }
            }
        });
        return button;
    }

    private void createOrientationInfoContent(FormToolkit formToolkit) {
        this.orientationGroup = this.createGroup("\u6839\u636e\u91cd\u529b\u611f\u5e94\u81ea\u52a8\u6a2a\u7ad6\u5c4f", formToolkit);
        Composite orientationComposite = formToolkit.createComposite((Composite)this.orientationGroup);
        orientationComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        orientationComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(40, 40, 10, 20).numColumns(4).spacing(40, 10).create());
        GridDataFactory gridDataFactory = GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, false);
        this.portraitButton = new PrettyToggleButton(orientationComposite, 0, ResourceManager.getPluginImage("com.pandora.editor.ui", "icons/full/Portrait.png"));
        this.portraitButton.setLayoutData((Object)gridDataFactory.create());
        formToolkit.adapt((Control)this.portraitButton, true, true);
        this.upsideDownButton = new PrettyToggleButton(orientationComposite, 0, ResourceManager.getPluginImage("com.pandora.editor.ui", "icons/full/Upside_Down.png"));
        this.upsideDownButton.setLayoutData((Object)gridDataFactory.create());
        formToolkit.adapt((Control)this.upsideDownButton, true, true);
        this.landscapeLeftButton = new PrettyToggleButton(orientationComposite, 0, ResourceManager.getPluginImage("com.pandora.editor.ui", "icons/full/Landscape_Left.png"));
        this.landscapeLeftButton.setLayoutData((Object)gridDataFactory.create());
        formToolkit.adapt((Control)this.landscapeLeftButton, true, true);
        this.landscapeRightButton = new PrettyToggleButton(orientationComposite, 0, ResourceManager.getPluginImage("com.pandora.editor.ui", "icons/full/Landscape_Right.png"));
        this.landscapeRightButton.setLayoutData((Object)gridDataFactory.create());
        formToolkit.adapt((Control)this.landscapeRightButton, true, true);
        this.portraitCheck = formToolkit.createButton(orientationComposite, "portrait", 32);
        this.portraitCheck.setLayoutData((Object)gridDataFactory.create());
        this.upsideDownCheck = formToolkit.createButton(orientationComposite, "upside down", 32);
        this.upsideDownCheck.setLayoutData((Object)gridDataFactory.create());
        this.landscapeLeftCheck = formToolkit.createButton(orientationComposite, "landscape left", 32);
        this.landscapeLeftCheck.setLayoutData((Object)gridDataFactory.create());
        this.landscapeRightCheck = formToolkit.createButton(orientationComposite, "landscape right", 32);
        this.landscapeRightCheck.setLayoutData((Object)gridDataFactory.create());
        new PrettyToggleSelectioner(this.portraitCheck, this.portraitButton);
        new PrettyToggleSelectioner(this.upsideDownCheck, this.upsideDownButton);
        new PrettyToggleSelectioner(this.landscapeLeftCheck, this.landscapeLeftButton);
        new PrettyToggleSelectioner(this.landscapeRightCheck, this.landscapeRightButton);
    }

    private void bindErrorDecorations(FormToolkit formToolkit) {
        this.bindErrorValidation((Control)this.appnameText, "name", 0x1020000, formToolkit, new Control[]{this.appnameText});
        this.bindErrorValidation((Control)this.appidText, "id", 0x1020000, formToolkit, new Control[]{this.appidText});
        this.bindErrorValidation((Control)this.versionText, "version.name", 0x1020000, formToolkit, new Control[]{this.versionText});
        this.bindErrorValidation((Control)this.homePageText, "launch_path", 0x1020000, formToolkit, new Control[]{this.homePageText});
        this.bindErrorValidation((Control)this.debugCheck, "plus.distribute.debug", 0x1020000, formToolkit, new Control[]{this.debugCheck}).setMarginWidth(0);
        this.bindErrorValidation((Control)this.fullscreenCheck, "fullscreen", 0x1020000, formToolkit, new Control[]{this.fullscreenCheck}).setMarginWidth(0);
        this.bindErrorValidation((Control)this.runmodeLabel, "plus.runmode", 0x1020000, formToolkit, new Control[]{this.runmodeLiberateRadio, this.runmodeNormalRadio});
        this.bindErrorValidation((Control)this.orientationGroup, "plus.distribute.orientation", 0x1004000, formToolkit, new Control[]{this.portraitCheck, this.upsideDownCheck, this.landscapeLeftCheck, this.landscapeRightCheck, this.portraitButton, this.upsideDownButton, this.landscapeLeftButton, this.landscapeRightButton}).setMarginWidth(0);
    }

    @Override
    public void fromModule(ManifastConfiguration appConfig) {
        this.appnameText.setText(appConfig.getAppName());
        this.appidText.setText(appConfig.getAppid());
        if (this.appidText != null && !StringUtil.isBlank((String)this.appidText.getText())) {
            this.getAppidButton.setEnabled(false);
        }
        this.versionText.setText(appConfig.getVersion().getName());
        this.homePageText.setText(appConfig.getLaunch_path());
        this.debugCheck.setSelection(appConfig.getPlus().getDistribute().isDebug());
        this.fullscreenCheck.setSelection(appConfig.isFullscreen());
        String runmode = appConfig.getPlus().getRunmode();
        if ("liberate".equals(runmode)) {
            this.runmodeLiberateRadio.setSelection(true);
            this.runmodeNormalRadio.setSelection(false);
        } else if ("normal".equals(runmode)) {
            this.runmodeNormalRadio.setSelection(true);
            this.runmodeLiberateRadio.setSelection(false);
        }
        List orientation = appConfig.getPlus().getDistribute().getOrientation();
        this.portraitCheck.setSelection(orientation.contains("portrait-primary"));
        this.portraitButton.setSelect(this.portraitCheck.getSelection());
        this.upsideDownCheck.setSelection(orientation.contains("portrait-secondary"));
        this.upsideDownButton.setSelect(this.upsideDownCheck.getSelection());
        this.landscapeLeftCheck.setSelection(orientation.contains("landscape-primary"));
        this.landscapeLeftButton.setSelect(this.landscapeLeftCheck.getSelection());
        this.landscapeRightCheck.setSelection(orientation.contains("landscape-secondary"));
        this.landscapeRightButton.setSelect(this.landscapeRightCheck.getSelection());
    }

    @Override
    public void toModule(ManifastConfiguration appConfig) {
        appConfig.setAppName(this.appnameText.getText());
        appConfig.setAppid(this.appidText.getText());
        if (this.appidText != null && !StringUtil.isBlank((String)this.appidText.getText())) {
            this.getAppidButton.setEnabled(false);
        } else {
            this.getAppidButton.setEnabled(true);
        }
        appConfig.getVersion().setName(this.versionText.getText());
        appConfig.setLaunch_path(this.homePageText.getText());
        appConfig.getPlus().getDistribute().setDebug(this.debugCheck.getSelection());
        appConfig.setFullscreen(this.fullscreenCheck.getSelection());
        if (this.runmodeLiberateRadio.getSelection()) {
            appConfig.getPlus().setRunmode("liberate");
        } else if (this.runmodeNormalRadio.getSelection()) {
            appConfig.getPlus().setRunmode("normal");
        }
        List orientation = appConfig.getPlus().getDistribute().getOrientation();
        orientation.clear();
        if (this.portraitCheck.getSelection()) {
            orientation.add("portrait-primary");
        }
        if (this.upsideDownCheck.getSelection()) {
            orientation.add("portrait-secondary");
        }
        if (this.landscapeLeftCheck.getSelection()) {
            orientation.add("landscape-primary");
        }
        if (this.landscapeRightCheck.getSelection()) {
            orientation.add("landscape-secondary");
        }
    }

    private class PrettyToggleSelectioner
    extends SelectionAdapter
    implements PrettyToggleButton.ISelectListener {
        private PrettyToggleButton prettyToggleButton;
        private Button checkButton;

        public PrettyToggleSelectioner(Button checkButton, PrettyToggleButton prettyToggleButton) {
            this.checkButton = checkButton;
            this.prettyToggleButton = prettyToggleButton;
            checkButton.addSelectionListener((SelectionListener)this);
            prettyToggleButton.addSelectListener((PrettyToggleButton.ISelectListener)this);
        }

        public void select(PrettyToggleButton toggleButton, boolean userClick) {
            if (userClick && this.checkButton.getSelection() != this.prettyToggleButton.isSelect()) {
                this.checkButton.setSelection(toggleButton.isSelect());
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.prettyToggleButton != null && this.checkButton.getSelection() != this.prettyToggleButton.isSelect()) {
                this.prettyToggleButton.setSelect(this.checkButton.getSelection(), false);
            }
        }
    }
}

