/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.ui.editors.pages;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.editor.common.contentassist.Helper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.pandora.core.appstream.AppStream;
import com.pandora.core.appstream.AppStreamFileBuilder;
import com.pandora.core.appstream.Page;
import com.pandora.core.project.HMobileConvertor;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.StreamJsonUtil;
import com.pandora.editor.ui.editors.AppConfigEditor;
import com.pandora.editor.ui.editors.views.HTMLViewerFilter;
import com.pandora.editor.ui.editors.views.HTMLViewerLabelProvider;
import com.pandora.editor.ui.editors.views.ProjectFilter;
import com.pandora.editor.ui.editors.views.StreamPageDependenciesEditor;
import com.pandora.editor.ui.editors.views.StreamViewerSorter;
import com.pandora.launcher.ui.DeviceManager;
import com.pandora.launcher.ui.LauncherActivator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.wb.swt.ResourceManager;

public class AppStreamConfigPage
extends FormPage {
    private StreamPageDependenciesEditor fActiveDependenciesEditor = null;
    private AppStreamFileBuilder fAppStreamBuilder = null;
    private Composite fRightPane = null;
    private Map fDependencies = null;
    private Map fDiffDependencies = null;
    private TreeViewer fHTMLViewer = null;
    private AppConfigEditor fConfigEditor = null;
    private IDocumentListener fDocumentListener = null;

    public AppStreamConfigPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
        this.fConfigEditor = (AppConfigEditor)editor;
        this.fDependencies = new LinkedHashMap();
        this.fAppStreamBuilder = new AppStreamFileBuilder();
    }

    public void setDependencies(Map dependencies) {
        if (this.fDependencies == null) {
            this.fDependencies = dependencies;
        } else if (CollectionsUtil.isNotEmpty((Map)dependencies)) {
            if (dependencies.containsKey("pages")) {
                this.fDependencies.put("pages", dependencies.get("pages"));
            }
            if (dependencies.containsKey("idle")) {
                this.fDependencies.put("idle", dependencies.get("idle"));
            }
        } else {
            this.fDependencies = dependencies;
        }
    }

    public Map getDiffDependencies() {
        return this.fDiffDependencies;
    }

    public Map getDependencies() {
        return this.fDependencies;
    }

    public Map getPageDependencies() {
        if (this.fDependencies != null && this.fDependencies.containsKey("pages")) {
            return (Map)this.fDependencies.get("pages");
        }
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        FormToolkit formToolkit = managedForm.getToolkit();
        Composite parent = managedForm.getForm().getBody();
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        Composite pageContent = formToolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(pageContent);
        GridDataFactory.fillDefaults().grab(true, true).minSize(1000, 700).applyTo((Control)pageContent);
        this.createHeader(formToolkit, pageContent);
        formToolkit.createLabel(pageContent, this.getTitle(), 258).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite bodyContent = formToolkit.createComposite(pageContent, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(1000, 700).applyTo((Control)bodyContent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(bodyContent);
        SashForm sashForm = new SashForm(bodyContent, 256);
        GridDataFactory.fillDefaults().grab(true, true).hint(0, 800).applyTo((Control)sashForm);
        sashForm.setLayout((Layout)new FillLayout());
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).applyTo((Composite)sashForm);
        Composite leftPane = formToolkit.createComposite((Composite)sashForm, 0);
        this.createLeftContent(leftPane);
        this.fRightPane = formToolkit.createComposite((Composite)sashForm, 0x20000000);
        this.fRightPane.setBackground(ResourceManager.getColor(240, 240, 240));
        GridLayoutFactory.fillDefaults().applyTo(this.fRightPane);
        sashForm.setWeights(new int[]{20, 80});
        this.showHelpInfo();
    }

    protected void createHeader(FormToolkit formToolkit, Composite pageContent) {
        Composite titleContent = formToolkit.createComposite(pageContent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleContent);
        FormLayout fl = new FormLayout();
        fl.marginBottom = 5;
        fl.marginTop = 5;
        fl.marginRight = 10;
        fl.marginLeft = 10;
        titleContent.setLayout((Layout)fl);
        Label titleLabel = formToolkit.createLabel(titleContent, "\u9879\u76ee\u3010" + this.getProject().getName() + "\u3011" + this.getTitle(), 0);
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 8);
        titleLabel.setLayoutData((Object)fData);
        Label tipsLabel = formToolkit.createLabel(titleContent, "Tips\uff1a3\u79cd\u65b9\u5f0f\u751f\u6210\u9875\u9762\u5f15\u7528\u5173\u7cfb\u3002");
        fData = new FormData();
        fData.top = new FormAttachment(0, 8);
        fData.left = new FormAttachment((Control)titleLabel, 15);
        tipsLabel.setLayoutData((Object)fData);
        Label one = formToolkit.createLabel(titleContent, "1.");
        fData = new FormData();
        fData.top = new FormAttachment(0, 8);
        fData.left = new FormAttachment((Control)tipsLabel, 5);
        one.setLayoutData((Object)fData);
        Hyperlink scanCodeLink = formToolkit.createHyperlink(titleContent, "\u626b\u63cf\u4ee3\u7801", 0);
        fData = new FormData();
        fData.top = new FormAttachment(0, 7);
        fData.left = new FormAttachment((Control)one, 0);
        scanCodeLink.setLayoutData((Object)fData);
        scanCodeLink.setForeground(scanCodeLink.getDisplay().getSystemColor(10));
        scanCodeLink.setUnderlined(true);
        scanCodeLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    AppStreamConfigPage.this.logUserOperateInfo(e);
                    AppStreamConfigPage.this.autoUpdateResourceDependencies();
                    AppStreamConfigPage.this.refresh();
                    MessageDialog dialog = AppStreamConfigPage.this.showMessageDialog("\u9875\u9762\u5f15\u7528\u5173\u7cfb\u5df2\u751f\u6210\u5b8c\u6bd5,\u56e0js\u5199\u6cd5\u8fc7\u4e8e\u7075\u6d3b,\u4ee3\u7801\u5206\u6790\u4e0d\u80fd\u4fdd\u8bc1\u5b8c\u5168\u6b63\u786e,\u63a8\u8350\u7528\u6237\u91cd\u70b9\u5173\u6ce8\u5217\u8868\u4e2d\u9ed1\u8272\u52a0\u7c97\u90e8\u5206\u662f\u5426\u6b63\u786e\u3002", new String[]{"\u786e\u5b9a"}, 0);
                    dialog.open();
                }
                catch (Exception e1) {
                    if (e1 instanceof RuntimeException) {
                        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)e1.getMessage());
                    }
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e1);
                }
            }
        });
        Label two = formToolkit.createLabel(titleContent, "2.");
        fData = new FormData();
        fData.top = new FormAttachment(0, 8);
        fData.left = new FormAttachment((Control)scanCodeLink, 10);
        two.setLayoutData((Object)fData);
        final Hyperlink mobileLink = formToolkit.createHyperlink(titleContent, "\u4f7f\u7528Android\u8bbe\u5907\u6216\u6a21\u62df\u5668\u771f\u673a\u8fd0\u884c(\u63a8\u8350)", 0);
        fData = new FormData();
        fData.top = new FormAttachment(0, 7);
        fData.left = new FormAttachment((Control)two, 0);
        mobileLink.setLayoutData((Object)fData);
        mobileLink.setForeground(mobileLink.getDisplay().getSystemColor(10));
        mobileLink.setUnderlined(true);
        mobileLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Menu menu = new Menu((Decorations)mobileLink.getShell(), 8);
                Rectangle rectangle = mobileLink.getBounds();
                Point pt = new Point(rectangle.x, rectangle.y + rectangle.height);
                pt = mobileLink.getParent().toDisplay(pt);
                if (PlatformUtil.isMac()) {
                    menu.setLocation(pt.x, pt.y + 5);
                } else {
                    menu.setLocation(pt.x, pt.y);
                }
                DeviceManager manager = LauncherActivator.getDefault().getDeviceManager();
                manager.initAndroidDevices(menu);
                menu.setVisible(true);
            }
        });
        mobileLink.forceFocus();
        Label three = formToolkit.createLabel(titleContent, "3.\u9009\u4e2d\u5de6\u4fa7\u6811\u4e2d\u6587\u4ef6\u624b\u52a8\u8c03\u6574");
        fData = new FormData();
        fData.top = new FormAttachment(0, 8);
        fData.left = new FormAttachment((Control)mobileLink, 10);
        three.setLayoutData((Object)fData);
    }

    protected void createToolbar(Composite head) {
    }

    public void logUserOperateInfo(HyperlinkEvent e) {
        try {
            Stats.addOperateInfo((String)"STREAM", (String)AppStreamConfigPage.class.getSimpleName(), (String)((Hyperlink)e.widget).getText());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void logUserOperateInfo(SelectionEvent e) {
        try {
            Stats.addOperateInfo((String)"STREAM", (String)AppStreamConfigPage.class.getSimpleName(), (String)e.text);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void autoUpdateIdle(final Shell parent) throws Exception {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(parent);
        monitorDialog.setOpenOnRun(true);
        monitorDialog.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AppStreamConfigPage.this.updateIdle();
                    parent.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AppStreamConfigPage.this.refresh();
                        }
                    });
                    monitor.done();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        MessageDialog dialog = this.showMessageDialog("\u5176\u4ed6\u8d44\u6e90\u5217\u8868\u5df2\u66f4\u65b0\u5b8c\u6bd5(\u5e26?\u89d2\u6807\u7684\u6587\u4ef6\u8868\u793a\u8be5\u6587\u4ef6\u6ca1\u6709\u88ab\u5176\u4ed6\u4efb\u4f55\u6587\u4ef6\u4f7f\u7528)", new String[]{"\u786e\u5b9a"}, 0);
        dialog.open();
    }

    protected void createLeftContent(Composite leftPane) {
        leftPane.setLayout((Layout)new FillLayout());
        Composite leftContent = new Composite(leftPane, 0);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        leftContent.setLayout((Layout)treeLayout);
        this.fHTMLViewer = new TreeViewer(leftContent, 65536);
        this.fHTMLViewer.setAutoExpandLevel(2);
        this.fHTMLViewer.setLabelProvider((IBaseLabelProvider)new HTMLViewerLabelProvider());
        this.fHTMLViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fHTMLViewer.setFilters(new ViewerFilter[]{new HTMLViewerFilter(), new ProjectFilter(this.getProject())});
        this.fHTMLViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.fHTMLViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AppStreamConfigPage.this.openEditor((StructuredViewer)AppStreamConfigPage.this.fHTMLViewer);
            }
        });
        this.fHTMLViewer.setSorter((ViewerSorter)new StreamViewerSorter());
        this.fHTMLViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection struct = (IStructuredSelection)selection;
                    Object first = struct.getFirstElement();
                    if (first instanceof IFile) {
                        AppStreamConfigPage.this.openDependenciesEditor((IFile)first);
                    } else {
                        AppStreamConfigPage.this.showHelpInfo();
                    }
                }
            }
        });
    }

    public void openEditor(StructuredViewer view) {
        ISelection selection = view.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                try {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            } else if (view instanceof TreeViewer) {
                ((TreeViewer)view).setExpandedState(obj, !((TreeViewer)view).getExpandedState(obj));
            }
        }
    }

    public TreeViewer getHTMLViewer() {
        return this.fHTMLViewer;
    }

    public AppConfigEditor getAppConfigEditor() {
        return this.fConfigEditor;
    }

    protected void showHelpInfo() {
        if (this.fActiveDependenciesEditor != null) {
            this.fActiveDependenciesEditor.dispose();
            this.fActiveDependenciesEditor = null;
        }
        this.disposeRightPaneChildrenControl();
        Composite fStreamPageEditorComposite = new Composite(this.fRightPane, 0x20000000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fStreamPageEditorComposite);
        GridLayoutFactory.fillDefaults().applyTo(fStreamPageEditorComposite);
        Label info = new Label(fStreamPageEditorComposite, 64);
        info.setForeground(info.getDisplay().getSystemColor(16));
        info.setFont(new Font((Device)info.getDisplay(), "\u5fae\u8f6f\u96c5\u9ed1", 14, 0));
        info.setImage(ResourceManager.getPluginImage("com.pandora.editor.ui", "icons/readme.png"));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(652, 520).grab(true, true).applyTo((Control)info);
        info.pack();
        this.fRightPane.layout(true);
    }

    public boolean openDependenciesEditor(IFile input) {
        return this.openDependenciesEditor(input, false);
    }

    public boolean openDependenciesEditor(IFile input, boolean forceUpdate) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(input.getName());
        if (contentType == null || !"com.aptana.contenttype.html".equals(contentType.getId())) {
            MessageBox box = new MessageBox(this.getSite().getShell(), 8);
            box.setMessage("\u8be5\u6587\u4ef6\u4e0d\u542b\u5176\u5b83\u8d44\u6e90\u6216\u53ef\u6253\u5f00\u7684\u6b21\u7ea7\u9875\u9762");
            box.setText(this.getTitle());
            box.open();
            return false;
        }
        if (this.isOpened(input) && !forceUpdate) {
            return false;
        }
        if (this.fActiveDependenciesEditor != null) {
            this.fActiveDependenciesEditor.dispose();
        }
        this.disposeRightPaneChildrenControl();
        this.fActiveDependenciesEditor = new StreamPageDependenciesEditor(input, this);
        Composite fStreamPageEditorComposite = new Composite(this.fRightPane, 0x20000000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fStreamPageEditorComposite);
        this.fActiveDependenciesEditor.createPartControl(fStreamPageEditorComposite);
        this.fRightPane.layout(true);
        this.fActiveDependenciesEditor.init(this.getDependencies(), this.getDiffDependencies());
        return true;
    }

    protected void disposeRightPaneChildrenControl() {
        Control[] controlArray = this.fRightPane.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (Helper.okToUse((Widget)child)) {
                child.dispose();
            }
            ++n2;
        }
    }

    private boolean isOpened(IFile input) {
        return this.fActiveDependenciesEditor != null && this.fActiveDependenciesEditor.getEditorInput() == input;
    }

    public IProject getProject() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            return fileInput.getFile().getProject();
        }
        return null;
    }

    public void refresh(boolean reopen) {
        IDocument document;
        String source;
        Gson gson = StreamJsonUtil.createGson();
        Map map = (Map)gson.fromJson(source = (document = ((AppConfigEditor)this.getEditor()).getSourceDocument()).get(), Map.class);
        if (map.containsKey("dependencies")) {
            this.setDependencies((Map)map.get("dependencies"));
        } else {
            this.setDependencies(new LinkedHashMap());
        }
        if (this.fActiveDependenciesEditor != null) {
            if (reopen) {
                this.openDependenciesEditor(this.fActiveDependenciesEditor.getEditorInput(), true);
            } else {
                this.fActiveDependenciesEditor.init(this.getDependencies(), this.getDiffDependencies());
                this.fActiveDependenciesEditor.refresh();
            }
        }
    }

    public void refresh() {
        this.refresh(true);
    }

    public void activated() {
        try {
            Stats.addOperateInfo((String)"STREAM", (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"activated");
            IDocument document = this.fConfigEditor.getSourceDocument();
            AppStreamFileBuilder.jsonToMap((IFile)this.fConfigEditor.getEditFile(), (Gson)new Gson(), (IDocument)document);
            this.waitingForGenerateResourceDependencies();
            if (this.fDocumentListener == null) {
                this.fDocumentListener = new IDocumentListener(){

                    public void documentChanged(DocumentEvent event) {
                        if (AppStreamConfigPage.this.isActive()) {
                            AppStreamConfigPage.this.refresh(false);
                        }
                    }

                    public void documentAboutToBeChanged(DocumentEvent event) {
                    }
                };
                document.addDocumentListener(this.fDocumentListener);
            }
            if (this.fDiffDependencies == null) {
                this.initDiffDependencies();
            }
            if (this.fDiffDependencies != null) {
                this.updateDiffDependencies(document);
            }
            this.refresh();
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
            this.showError(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateDiffDependencies(IDocument document) {
        try {
            Gson gson = new Gson();
            Map newMap = (Map)gson.fromJson(document.get(), Map.class);
            if (newMap.containsKey("dependencies")) {
                Map dependencies = (Map)newMap.get("dependencies");
                if (dependencies.containsKey("pages")) {
                    Map pages = (Map)newMap.get("pages");
                    Map tempDiffs = (Map)gson.fromJson(gson.toJson((Object)this.fDiffDependencies), Map.class);
                    this.reducePageResources(tempDiffs, pages);
                    this.reducePageResources(this.fDiffDependencies, tempDiffs);
                } else {
                    this.fDiffDependencies.clear();
                }
            } else {
                this.fDiffDependencies.clear();
            }
            this.updateDiffDependencies2HTMLViewer();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void reducePageResources(Map srcMap, Map reduceMap) {
        if (srcMap == null || reduceMap == null) {
            return;
        }
        for (Object key : srcMap.keySet()) {
            Collection diffList;
            if (!reduceMap.containsKey(key)) continue;
            Map page = (Map)reduceMap.get(key);
            Map diffPage = (Map)srcMap.get(key);
            if (diffPage.containsKey("refer")) {
                diffList = (Collection)diffPage.get("refer");
                if (page.containsKey("refer")) {
                    diffList.removeAll((Collection)page.get("refer"));
                }
            }
            if (!diffPage.containsKey("resources")) continue;
            diffList = (Collection)diffPage.get("resources");
            if (!page.containsKey("resources")) continue;
            diffList.removeAll((Collection)page.get("resources"));
        }
    }

    protected void showError(JsonSyntaxException e) {
        MultiStatus status = new MultiStatus("com.pandora.editor.ui", 0, "manifest.json\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u590d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", null);
        String message = e.getMessage();
        status.add((IStatus)new Status(4, "com.pandora.editor.ui", message.substring(message.indexOf(":") + 1)));
        ErrorDialog errorDialog = new ErrorDialog(this.getSite().getShell(), "\u9875\u9762\u5f15\u7528\u5173\u7cfb", null, (IStatus)status, 4);
        errorDialog.open();
        this.getAppConfigEditor().setActivePage("com.pandora.editor.appconfig.jsonsource");
    }

    protected void initDiffDependencies() {
        try {
            IFile file = this.getProject().getFile("unpackage/.dependencies");
            if (file.exists()) {
                File f = file.getLocation().makeAbsolute().toFile();
                String content = FileUtils.readFileToString((File)f);
                this.fDiffDependencies = (Map)new Gson().fromJson(content, Map.class);
                this.updateDiffDependencies2HTMLViewer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void waitingForGenerateResourceDependencies() throws Exception {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        monitorDialog.setOpenOnRun(true);
        Gson gson = StreamJsonUtil.createGson();
        IDocument document = this.fConfigEditor.getSourceDocument();
        final HMobileProject mobileProject = HMobileConvertor.convert((IProject)this.getProject());
        this.checkAppStreamFile(monitorDialog, mobileProject);
        Map map = (Map)gson.fromJson(document.get(), Map.class);
        if (map.containsKey("dependencies")) {
            return;
        }
        boolean md = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"\u63d0\u793a", (String)"\u68c0\u6d4b\u5230\u8fd8\u6ca1\u6709\u9875\u9762\u5f15\u7528\u5173\u7cfb\u6570\u636e\uff0c\u662f\u5426\u901a\u8fc7\u626b\u63cf\u4ee3\u7801\u81ea\u52a8\u751f\u6210\uff1f");
        if (!md) {
            return;
        }
        IFile file = this.getProject().getFile("unpackage/.dependencies");
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        monitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        monitorDialog.setOpenOnRun(true);
        monitorDialog.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AppStreamFileBuilder fileBuilder = new AppStreamFileBuilder();
                try {
                    Map map = fileBuilder.build(mobileProject, monitor);
                    if (map == null || monitor.isCanceled()) {
                        return;
                    }
                    try {
                        AppStreamConfigPage.this.fConfigEditor.updateManifestJSON(map, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    protected HMobileProject checkAppStreamFile(ProgressMonitorDialog monitorDialog, final HMobileProject mobileProject) throws Exception {
        final AppStreamFileBuilder builder = new AppStreamFileBuilder();
        final IFile streamFile = this.getProject().getFile("appstream.json");
        boolean hasExpired = builder.hasAlertAppstreamFileIsExpired(mobileProject);
        if (streamFile.exists() && !hasExpired) {
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("\u6b63\u5728\u5408\u5e76appstream.json\u6587\u4ef6...", 100);
                            Gson gson = new Gson();
                            File f = FileUtil.convertIFileToFile((IFile)streamFile);
                            String jsonContent = FileUtils.readFileToString((File)f);
                            AppStream appStream = (AppStream)gson.fromJson(jsonContent, AppStream.class);
                            appStream.addPage(appStream.getMain().getHref(), appStream.getMain());
                            appStream.setWgt(null);
                            appStream.setUrl(null);
                            appStream.setProtocol(null);
                            appStream.setVersion(null);
                            appStream.setMain(null);
                            Map pages = appStream.getPages();
                            HashMap clone = new HashMap();
                            clone.putAll(pages);
                            for (Map.Entry entry : clone.entrySet()) {
                                appStream.addPage(((Page)entry.getValue()).getHref(), (Page)entry.getValue());
                            }
                            String json = gson.toJson((Object)appStream);
                            Map newMap = (Map)gson.fromJson(json, Map.class);
                            Map oldMap = (Map)gson.fromJson(AppStreamConfigPage.this.fConfigEditor.getSourceDocument().get(), Map.class);
                            if (oldMap.containsKey("dependencies")) {
                                Map depens = (Map)oldMap.get("dependencies");
                                StreamJsonUtil.unionDepens((Map)newMap, (Map)depens);
                                AppStreamConfigPage.this.computerIdle(depens);
                                AppStreamConfigPage.this.fConfigEditor.updateManifestJSON(depens, false);
                            } else {
                                AppStreamConfigPage.this.fConfigEditor.updateManifestJSON(newMap, true);
                            }
                            builder.setAlertAppstreamFileIsExpired(mobileProject, true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            MessageDialog dialog = this.showMessageDialog("appstream.json\u5df2\u88ab\u5e9f\u5f03\uff0c\u76f8\u5173\u5185\u5bb9\u5df2\u5408\u5e76\u81f3manifest.json\u7684dependencies\u8282\u70b9\u4e0b\uff0c\u5982\u9700\u4fee\u6539\uff0c\u8bf7\u5728manifest\u53ef\u89c6\u5316\u754c\u9762\u4fee\u6539\u9875\u9762\u5e94\u7528\u5173\u7cfb\u3002\u662f\u5426\u5220\u9664appstream.json\uff1f", new String[]{"\u662f", "\u5426"}, 0);
            int value = dialog.open();
            switch (value) {
                case 0: {
                    streamFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
            }
        }
        return mobileProject;
    }

    public MessageDialog showMessageDialog(String message, String[] buttonLabel, int defaultIndex) {
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), this.getTitle(), this.getSite().getShell().getImage(), message, 2, buttonLabel, defaultIndex);
        return dialog;
    }

    public void computerIdle(Map depens) {
        Map idle = this.fAppStreamBuilder.queryIdleResources(depens, this.getProject());
        depens.put("idle", idle);
    }

    public void updateIdle() throws Exception {
        IDocument document = this.fConfigEditor.getSourceDocument();
        Map maps = (Map)new Gson().fromJson(document.get(), Map.class);
        if (maps.containsKey("dependencies")) {
            Map depens = (Map)maps.get("dependencies");
            this.computerIdle(depens);
            this.fConfigEditor.updateManifestJSON(depens, false);
        }
    }

    public void autoUpdateResourceDependencies() throws Exception {
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        monitorDialog.setOpenOnRun(true);
        final HMobileProject mobileProject = HMobileConvertor.convert((IProject)this.getProject());
        monitorDialog.run(true, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                AppStreamFileBuilder fileBuilder = new AppStreamFileBuilder();
                try {
                    try {
                        Map newMap = fileBuilder.build(mobileProject, monitor, true);
                        if (monitor.isCanceled() || newMap == null) {
                            throw new RuntimeException("\u7528\u6237\u53d6\u6d88\u4e86\u6784\u5efa\u884c\u4e3a\u3002");
                        }
                        IDocument document = AppStreamConfigPage.this.fConfigEditor.getSourceDocument();
                        Map oldMap = (Map)new Gson().fromJson(document.get(), Map.class);
                        if (oldMap.containsKey("dependencies")) {
                            Map depens = (Map)oldMap.get("dependencies");
                            AppStreamConfigPage.this.fDiffDependencies = AppStreamConfigPage.this.computeDiffDependencies(newMap, depens);
                            StreamJsonUtil.unionDepens((Map)newMap, (Map)depens);
                            AppStreamConfigPage.this.computerIdle(depens);
                            AppStreamConfigPage.this.fConfigEditor.updateManifestJSON(depens, false);
                        } else {
                            AppStreamConfigPage.this.fDiffDependencies = new LinkedHashMap();
                            AppStreamConfigPage.this.fDiffDependencies.put("pages", new LinkedHashMap());
                            AppStreamConfigPage.this.fConfigEditor.updateManifestJSON(newMap, true);
                        }
                        AppStreamConfigPage.this.updateDiffDependencies2HTMLViewer();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    public void saveDiffDependencies(Map diffMap) {
        block15: {
            Gson gson = StreamJsonUtil.createGson();
            IFolder folder = this.getProject().getFolder("unpackage");
            if (!folder.exists()) {
                try {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            IFile file = this.getProject().getFile("unpackage/.dependencies");
            String content = gson.toJson((Object)diffMap);
            StringBufferInputStream sbStream = new StringBufferInputStream(content);
            try {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)sbStream, true, true, (IProgressMonitor)new NullProgressMonitor());
                        break block15;
                    }
                    file.create((InputStream)sbStream, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    try {
                        sbStream.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    sbStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Map computeDiffDependencies(Map newDepens, Map oldDepens) {
        Gson gson = new Gson();
        newDepens = (Map)gson.fromJson(gson.toJson((Object)newDepens), Map.class);
        oldDepens = (Map)gson.fromJson(gson.toJson((Object)oldDepens), Map.class);
        LinkedHashMap diffMap = new LinkedHashMap();
        if (!newDepens.containsKey("pages")) {
            return diffMap;
        }
        if (oldDepens == null || !oldDepens.containsKey("pages")) {
            diffMap.putAll((Map)newDepens.get("pages"));
            return diffMap;
        }
        Map newPages = (Map)newDepens.get("pages");
        Map oldPages = (Map)oldDepens.get("pages");
        HashSet removeKeys = new HashSet();
        for (Object key : newPages.keySet()) {
            Collection newResources;
            if (!oldPages.containsKey(key)) continue;
            Map oldPage = (Map)oldPages.get(key);
            Map newPage = (Map)newPages.get(key);
            ArrayList oldResources = new ArrayList();
            if (oldPage.containsKey("resources")) {
                oldResources.addAll((Collection)oldPage.get("resources"));
            }
            if (oldPage.containsKey("refer")) {
                oldResources.addAll((Collection)oldPage.get("refer"));
            }
            boolean empty = true;
            if (newPage.containsKey("resources")) {
                newResources = (Collection)newPage.get("resources");
                newResources.removeAll(oldResources);
                empty = newResources.isEmpty();
            }
            if (newPage.containsKey("refer")) {
                newResources = (Collection)newPage.get("refer");
                newResources.removeAll(oldResources);
                boolean bl = empty = newResources.isEmpty() && empty;
            }
            if (!empty) continue;
            removeKeys.add(key);
        }
        for (Object key : removeKeys) {
            newPages.remove(key);
        }
        return newPages;
    }

    public void updateDiffDependencies2HTMLViewer() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                HTMLViewerLabelProvider labelProvider = (HTMLViewerLabelProvider)AppStreamConfigPage.this.getHTMLViewer().getLabelProvider();
                labelProvider.setDiffDependencies(AppStreamConfigPage.this.fDiffDependencies);
                AppStreamConfigPage.this.getHTMLViewer().refresh();
            }
        });
    }
}

