/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.pack.core.viewpack;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.pack.core.PackActivator;
import com.pandora.pack.core.PackPlatform;
import com.pandora.pack.core.viewpack.PackageStatus;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ViewPackStatusManager {
    public static Set<PackageStatus> generateAppPackageStatus(String appid) {
        HttpClientUtils httpClientUtils = HttpClientUtils.getInstance((String)"ProjectAction!getHistoryPackage");
        httpClientUtils.addRequestBody("appid", appid);
        ResponseObj responseObj = httpClientUtils.excute();
        TreeSet<PackageStatus> list = new TreeSet<PackageStatus>();
        if (!responseObj.isOk()) {
            return list;
        }
        JSONObject body = responseObj.getBody();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ViewPackStatusManager.transPackStatus(PackPlatform.IOS_PB, list, body, f, false);
        ViewPackStatusManager.transPackStatus(PackPlatform.IOS_ADHOC, list, body, f, true);
        ViewPackStatusManager.transPackStatus(PackPlatform.IOS_APPSTORE, list, body, f, true);
        ViewPackStatusManager.transPackStatus(PackPlatform.ANDROID_PB, list, body, f, false);
        ViewPackStatusManager.transPackStatus(PackPlatform.ANDROID_GOOGLEPLAY, list, body, f, true);
        return list;
    }

    private static void transPackStatus(PackPlatform platform, TreeSet<PackageStatus> list, JSONObject body, SimpleDateFormat f, boolean licensed) {
        if (body != null && body.has(platform.toString())) {
            JSONArray ios = null;
            try {
                ios = body.getJSONArray(platform.toString());
            }
            catch (JSONException e) {
                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                return;
            }
            if (ios == null) {
                return;
            }
            int i = 0;
            while (i < ios.length()) {
                try {
                    JSONObject jsonObject = ios.getJSONObject(i);
                    PackageStatus packageStatus = new PackageStatus();
                    packageStatus.setPlatform(platform);
                    String version = (String)jsonObject.keys().next();
                    packageStatus.setVersion(version);
                    jsonObject = jsonObject.getJSONObject(version);
                    if (jsonObject.has("ticket")) {
                        packageStatus.setTicket(jsonObject.getString("ticket"));
                    }
                    packageStatus.setLicensed(licensed);
                    if (jsonObject.has("errorcode")) {
                        packageStatus.setErrorCode(jsonObject.getString("errorcode"));
                    }
                    if (jsonObject.has("packagename")) {
                        packageStatus.setPackageName(jsonObject.getString("packagename"));
                    }
                    try {
                        packageStatus.setPackageTime(f.parse(jsonObject.getString("packagetime")));
                    }
                    catch (ParseException e) {
                        IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                    }
                    String status = jsonObject.getString("status");
                    packageStatus.setStatus(status);
                    if (jsonObject.has("url")) {
                        packageStatus.setUrl(jsonObject.getString("url"));
                    }
                    if (jsonObject.has("buildlog")) {
                        packageStatus.setBuildlog(jsonObject.getString("buildlog"));
                    }
                    list.add(packageStatus);
                }
                catch (JSONException e) {
                    IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)e);
                }
                ++i;
            }
        }
    }

    public static boolean canCancelAppPackage(String status, String ticket) {
        return StringUtil.isNotBlank((String)status) && "INQUEUE".equals(status) && StringUtil.isNotBlank((String)ticket);
    }

    public static boolean cancelAppPackage(String appid, boolean confirm) {
        block6: {
            ArrayList<String> tickets;
            block7: {
                Set<PackageStatus> packageStatuses;
                block5: {
                    packageStatuses = ViewPackStatusManager.generateAppPackageStatus(appid);
                    if (packageStatuses != null && !packageStatuses.isEmpty()) break block5;
                    return true;
                }
                tickets = new ArrayList<String>();
                for (PackageStatus packageStatus : packageStatuses) {
                    if (!ViewPackStatusManager.canCancelAppPackage(packageStatus.getStatus(), packageStatus.getTicket())) continue;
                    tickets.add(packageStatus.getTicket());
                }
                if (tickets.isEmpty()) break block6;
                if (!confirm) break block7;
                final boolean[] result = new boolean[]{true};
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = Display.getDefault().getActiveShell();
                        if (shell != null) {
                            result[0] = MessageDialog.openConfirm((Shell)shell, (String)"\u63d0\u9192", (String)"\u68c0\u6d4b\u5230\u672c\u9879\u76ee\u5df2\u6709\u6b63\u5728\u5236\u4f5c\u7684\u5b89\u88c5\u5305\u5728\u4e91\u7aef\u961f\u5217\u4e2d,\u7ee7\u7eed\u6253\u5305\u5c06\u53d6\u6d88\u4e91\u7aef\u961f\u91cc\u4e2d\u7684\u5236\u4f5c\u5e76\u91cd\u65b0\u6392\u961f,\u662f\u5426\u7ee7\u7eed\u63d0\u4ea4\uff1f");
                        }
                    }
                });
                if (result[0]) break block7;
                return false;
            }
            try {
                ViewPackStatusManager.cancelAppPackage(tickets);
            }
            catch (Exception ex) {
                IdeLog.logError((Plugin)PackActivator.getDefault(), (Throwable)ex);
            }
        }
        return true;
    }

    public static ResponseObj cancelAppPackage(List<String> tickets) {
        if (tickets != null && !tickets.isEmpty()) {
            HttpClientUtils httpclient = HttpClientUtils.getInstance((String)"ProjectAction!cancelAppPackage");
            httpclient.addRequestBody("tickets", tickets);
            return httpclient.excute(null, null, false, true);
        }
        return null;
    }
}

